<?php // utf-8 marker: äöü 

if (!function_exists('sv') || preg_match('#templatefuncs/templatefuncs.php#i', $_SERVER['SCRIPT_NAME']))
{
	die('no direct access');
}

/*
============================================================
Template Addon "TemplateFuncs"
Standd 2019-03
Copyright: Gert Ebersbach - www.ge-webdesign.de
============================================================ 
*/


##################################################
// functions
##################################################

// NEWSBOXES function (wechselnde Newsboxen)

function tf_newsboxes($tf_nb_name, $tf_nb_low, $tf_nb_high, $tf_nb_type = NULL)
{
	if($tf_nb_type == 'random')
	{
		return newsbox($tf_nb_name . mt_rand($tf_nb_low, $tf_nb_high));
	}
	else
	{
		if(!isset($_SESSION))
		{
			session_start();
		}
		
		if(!$_SESSION[$tf_nb_name . 'tf_newsboxes_ordered'] || $_SESSION[$tf_nb_name . 'tf_newsboxes_ordered'] < $tf_nb_low || $_SESSION[$tf_nb_name . 'tf_newsboxes_ordered'] > $tf_nb_high)
		{
			$_SESSION[$tf_nb_name . 'tf_newsboxes_ordered'] = $tf_nb_low - 1;
		}
		
		$_SESSION[$tf_nb_name . 'tf_newsboxes_ordered'] < $tf_nb_high ? $_SESSION[$tf_nb_name . 'tf_newsboxes_ordered'] ++ : $_SESSION[$tf_nb_name . 'tf_newsboxes_ordered'] = $tf_nb_low;
		
		return newsbox($tf_nb_name . $_SESSION[$tf_nb_name . 'tf_newsboxes_ordered']);
	}
}


// IMAGES function (wechselnde Bilder)

function tf_images($tf_img_folder, $tf_img_type = NULL)
{
	global $pth;
	
	$tf_img_high = 0;
	
	// define images path
	$tf_images_path = $pth['folder']['template'] . 'templatefuncs/' . $tf_img_folder . '/';

	// create images array
	if($tf_imagesFolderHandle = @opendir($tf_images_path))
	{
		while($tf_imagesFile = readdir($tf_imagesFolderHandle))
		{
			if($tf_imagesFile != '.' && $tf_imagesFile != '..' && $tf_imagesFile != 'index.html')
			{
				$tf_imagesFilesArray[] = $tf_imagesFile;
				sort($tf_imagesFilesArray);
			}
		}
		closedir($tf_imagesFolderHandle);
	}
	$tf_img_high = count($tf_imagesFilesArray);
	$tf_img_low = 1;
	
	if($tf_img_type == 'random')
	{
		return $pth['folder']['template'] . 'templatefuncs/' . $tf_img_folder . '/' . $tf_imagesFilesArray[mt_rand($tf_img_low, $tf_img_high) - 1];
	}
	else
	{
		if(!isset($_SESSION))
		{
			session_start();
		}
		
		if(!$_SESSION['tf_images_' . $tf_img_folder] || $_SESSION['tf_images_' . $tf_img_folder] < $tf_img_low || $_SESSION['tf_images_' . $tf_img_folder] > $tf_img_high)
		{
			$_SESSION['tf_images_' . $tf_img_folder] = 0;
		}
		
		$_SESSION['tf_images_' . $tf_img_folder] < $tf_img_high ? $_SESSION['tf_images_' . $tf_img_folder] ++ : $_SESSION['tf_images_' . $tf_img_folder] = $tf_img_low;
		
		return $pth['folder']['template'] . 'templatefuncs/' . $tf_img_folder . '/' . $tf_imagesFilesArray[$_SESSION['tf_images_' . $tf_img_folder] - 1];
	}
}

// SPECIAL LINKS function

// tf_homelink
function tf_homelink($file_icon = '')
{
	global $pth, $tx;

	echo '<a href="./">' . 	tag('img src="' . $pth['folder']['template'] . 'templatefuncs/icons/' . $file_icon . '" class="tf_homelink_icon" title="' . $tx['locator']['home'] . '" alt="' . $tx['locator']['home'] . '"') . '</a>';
}

// tf_printlink
function tf_printlink($file_icon = '') 
{
	global $f, $search, $file, $sn, $tx, $pth;
	$t = amp().'print';
	$title = $tx['menu']['print'];

	if ($f == 'search')
		$t .= amp() . 'function=search' . amp() . 'search=' . htmlspecialchars(stsl($search));
	else if ($f == 'file')
		$t .= amp() . 'file=' . $file;
	else if ($f != '' && $f != 'save')
		$t .= amp() . $f;
	else if (sv('QUERY_STRING') != '')
		$t = htmlspecialchars(sv('QUERY_STRING'), ENT_QUOTES, "UTF-8") . $t;
	
	$link = '';

	if ($file_icon != '') 
	{
		$link = tag('img src="' . $pth['folder']['template'] . 'templatefuncs/icons/' . $file_icon . '" class="tf_printlink_icon" title="' . $title . '" alt="' . $title . '"');
	}
	else 
	{ 
		$link .= $title; 
	}

    return '<a href="./?'.$t.'">' . $link . '</a>';
}

// tf_mailformlink
function tf_mailformlink($file_icon = '')
{
	global $cf, $pth, $tx;
	
	if($cf['mailform']['email'] != '')
	{
		echo '<a href="./?&amp;mailform">' . tag('img src="' . $pth['folder']['template'] . 'templatefuncs/icons/' . $file_icon . '" class="tf_mailformlink_icon" title="' . $tx['menu']['mailform'] . '" alt="' . $tx['menu']['mailform'] . '"') . '</a>';
	}
}

// tf_sitemaplink
function tf_sitemaplink($file_icon = '')
{
	global $pth, $tx;

	echo '<a href="./?&amp;sitemap">' . tag('img src="' . $pth['folder']['template'] . 'templatefuncs/icons/' . $file_icon . '" class="tf_sitemaplink_icon" title="' . $tx['menu']['sitemap'] . '" alt="' . $tx['menu']['sitemap'] . '"') . '</a>';
}

// tf_previouspage
function tf_previouspage($file_icon = '') 
{
	global $pth, $tx, $s, $cl, $tx, $adm;
	for ($i = $s - 1; $i > -1; $i--)
		if (!hide($i))
		{
			return a($i, '') . tag('img src="' . $pth['folder']['template'] . 'templatefuncs/icons/' . $file_icon . '" class="tf_prev_icon" title="' . $tx['navigator']['previous'] . '" alt="' . $tx['navigator']['previous'] . '"') . '</a>';
		}
}

// tf_nextpage
function tf_nextpage($file_icon = '') 
{
	global $pth, $tx, $s, $cl, $tx, $adm;
	for ($i = $s + 1; $i < $cl; $i++)
		if (!hide($i))
		{
			return a($i, '') . tag('img src="' . $pth['folder']['template'] . 'templatefuncs/icons/' . $file_icon . '" class="tf_next_icon" title="' . $tx['navigator']['next'] . '" alt="' . $tx['navigator']['next'] . '"') . '</a>';
		}
}

// tf_top
function tf_top($file_icon = '') 
{
	global $pth, $tx, $adm;
		return '<a href="#TOP">' . tag('img src="' . $pth['folder']['template'] . 'templatefuncs/icons/' . $file_icon . '" class="tf_top_icon" title="' . $tx['navigator']['top'] . '" alt="' . $tx['navigator']['top'] . '"') . '</a>';
}


// OPEN MENU function

function openMenu($start = NULL, $end = NULL)
{
	global $cl, $s, $l, $cf;
	if (isset($start)) 
	{
		if (!isset($end))
		{
			$end = $start;
		}
	}
	else
	{
		$start = 1;
	}
	
	if (!isset($end))
	{
		$end = $cf['menu']['levels'];
	}
	
	$openTocArray = array();
	
	if ($s > -1) 
	{
		for ($i = $s; $i > -1; $i--) 
		{
			if ($l[$i] >= $start && $l[$i] <= $end)
			{
				if (!hide($i) || ($i == $s && $cf['hidden']['pages_toc'] == 'true'))
				{
					$openTocArray[] = $i;
				}
			}
		}
		@sort($openTocArray);
	}
	
	for ($i = $s + 1; $i < $cl; $i++) 
	{
		if ($l[$i] >= $start && $l[$i] <= $end)
		{
			if (!hide($i))
			{
				$openTocArray[] = $i;
			}
		}
	}
	
	return li($openTocArray, $start);
}


// LOCATOR function

function tf_locator($locatorDelimiter = '&gt;') 
{
    global $title, $h, $s, $f, $c, $l, $tx, $adm, $cf, $pth; 
	
	if (hide($s) && $cf['hidden']['path_locator'] != 'true')
		return '<span class="cmsimpleLocatorElement">' . str_replace('_splitToc_','',$h[$s]) . '</span>';
	if ($title != '' && (!isset($h[$s]) || $h[$s] != $title))
		return '<span class="cmsimpleLocatorElement">' . str_replace('_splitToc_','',$title) . '</span>';
	$t = '';
	if ($s == 0)
		return '<h1>' . str_replace('_splitToc_','',$h[$s]) . '</h1>';
	elseif ($f != '')
		return ucfirst($f);
	elseif ($s > 0) {
		$tl = $l[$s];
		if ($tl > 1) 
		{
			for ($i = $s - 1; $i >= 0; $i--) 
			{
				if ($l[$i] < $tl) 
				{
					$t = '<span class="cmsimpleLocatorElement">' . a($i, '') . $h[$i] . '</a> ' . $locatorDelimiter . ' </span> ' . "\n" . $t;
					$tl--;
				}
				if ($tl < 2)
					break;
			}
		}
		if ($cf['locator']['show_homepage'] == 'true') {
		return "\n" . '<span class="cmsimpleLocatorElement">' .  a(0, '') . $tx['locator']['home'] . '</a> ' . $locatorDelimiter . ' </span> ' . "\n" . $t . '<h1>' . pagename() . '</h1> ';
		} 
		else 
		{
			return "\n" . $t . '<h1>' . pagename() . '</h1>';
		}
	}
	else
	{
		return '&nbsp;';
	}
}


// SUBMENU function

function tf_submenu() 
{
	global $s, $cl, $l, $tx, $cf, $adm;
	$ta = array();
	if ($s > -1) {
		$tl = $l[$s] + 1 + $cf['menu']['levelcatch'];
		for ($i = $s + 1; $i < $cl; $i++) {
			if ($l[$i] <= $l[$s])
				break;
			if ($l[$i] <= $tl)
				if (!hide($i) || $cf['hidden']['pages_submenu']=='true')
					$ta[] = $i;
			if ($l[$i] < $tl)
				$tl = $l[$i];
		}
		if (count($ta) != 0)
		{
			return '
<nav class="tplge_submenu">
<p>' . $tx['submenu']['heading'] . '</p>
' . li($ta, 'submenu') . '</nav>
';
		}
	}
}


// SIBLINGSMENU function

function tf_siblingsmenu() 
{
	global $l, $s, $tx;
	
	if(tf_submenu() == '' && $s >=0 && strstr(toc($l[$s],$l[$s]),'<a'))
	{
		return '
<nav class="tplge_siblingsmenu">
<p>' . $tx['submenu']['heading'] . '</p>' . toc($l[$s],$l[$s]) . '</nav>
';
	}
}


// SIBLINGS+SUBMENU function

function tf_subsibmenu() 
{
	global $l, $s, $tx;
	
	if($s >=0 && strstr(toc($l[$s],$l[$s]+1),'<a'))
	{
		return '
<nav class="tplge_subsibmenu">
<p>' . $tx['submenu']['heading'] . '</p>' . toc($l[$s],$l[$s]+1) . '</nav>
';
	}
}


// LANGUAGEMENU function

function tf_languagemenu() 
{
	$output = '';
	
	if(languagemenu() != '') 
	{
		$output = '
<nav class="tplge_langmenu">
' . languagemenu() . '
</nav>
';
	}
	return $output;
}


// SEARCHBOX function

function tf_searchbox() 
{
	global $sn, $tx;
	return '<form action="' . $sn . '" method="get">
<div class="tplge_searchboxContainer">
<input type="text" class="tplge_searchboxInput" name="search" size="12">
<input type="hidden" name="function" value="search">
<input type="submit" class="tplge_searchboxSubmit" title="' . $tx['search']['button'] . '" value="">
</div>
</form>
';
}


// SITENAME function

function tf_sitename()
{
	global $edit, $cf, $l, $s;
	
	$output = '<h2 class="tplge_sitename">
' . sitename() . '
</h2>';

	return $output . "\n";
}


// CONTENT function

function tf_contentNoPagename()
{
	global $cf,$edit;
	$output = '';
	
	if(!$edit)
	{
		if($cf['use']['h1only_pagesplitting'] == 'true')
		{
			$output.= preg_replace('~<h1 class="_level.*?</h1>~isu', '', content());
		}
		else
		{
			$output.= preg_replace("/<h[1-".$cf['menu']['levels']."].*<\/h[1-".$cf['menu']['levels']."]>/isu", "", content());
		}
	}
	else
	{
		$output.= content();
	}

	return $output . "\n";
}


// sanitized QUERY_STRING (for internal page navigation)

function tf_safeQueryString()
{
	$tf_safeQS = htmlspecialchars($_SERVER['QUERY_STRING'], ENT_QUOTES, 'UTF-8');
	$tf_safeQS = stripslashes(strip_tags($tf_safeQS));
	return $tf_safeQS;
}


?>