<?php

/*
============================================================
CMSimple Plugin CountDL
============================================================
Version:    CountDL 1.3
Released:   2024-03
Copyright:  Gert Ebersbach
Internet:   www.ge-webdesign.de
============================================================ 
utf-8 check: äöü 
*/

// based on:
/******************************************************/
/*					DL-Counter Light 1.0 			  */
/*				  Download-Counter (PHP)			  */
/*						Copyright 					  */
/*			(c) by Professor Dr. O. Lueth GmbH		  */
/*				 download latest version 			  */
/*			   www.download-counter.lueth.com	  	  */
/******************************************************/

$timestamp=time();
$aktuellJahr=date("Y",$timestamp);
$aktuellMonat=date("m",$timestamp);
$dateiAnzahlCounter=0;
$counterEinzelGesamt=array();
$counterEinzelName=array();
$counterGesamt=0;
$counterAktuellMonat=0;
$startJahr=2020;

$verzeichnis="./userfiles/downloads/countdl/";
$folderData="./content/plugins/countdl/";

if(is_dir($verzeichnis))
{
	$verzhandle=opendir($verzeichnis);
	$dateiListe=array();

	while($dateiName=readdir($verzhandle))
	{
		if(($dateiName!=".") && ($dateiName!=".."))
		{
			if(!(file_exists($folderData.$dateiName.$aktuellJahr.".txt")))
			{
				$dateihandle=fopen($folderData.$dateiName.$aktuellJahr.".txt", "w");
				for($i=0; $i<12; $i++)
				{
					fwrite($dateihandle, 0);
					fwrite($dateihandle, "\n");
				}
				fclose($dateihandle);
			}
		}
		$dateiListe[]=$dateiName;
	}
	sort($dateiListe);

	foreach($dateiListe as $dateiName)
	{
		$counterEinzelGesamt[$dateiAnzahlCounter]=0;
		if(($dateiName!=".") && ($dateiName!=".."))
		{
			for($a=$startJahr; $a<=$aktuellJahr; $a++)
			{
				if((file_exists($folderData.$dateiName.$a.".txt")))
				{
					$counterstand=file($folderData.$dateiName.$a.".txt");
					for($i=0; $i<12; $i++)
					{
						$counterEinzelGesamt[$dateiAnzahlCounter]+=$counterstand[$i];
						$counterGesamt+=$counterstand[$i];
						if($i==$aktuellMonat-1 && $a==$aktuellJahr)
						{
							$counterAktuellMonat+=$counterstand[$i];
						}
					}
				}
				else
				{
					$counterEinzelGesamt[$dateiAnzahlCounter]+=0;
				}
			}
			$counterEinzelName[$dateiAnzahlCounter]=$dateiName;
			$dateiAnzahlCounter++;
		}
	}
	closedir($verzhandle);
	$counterAktuellMonatW=$counterAktuellMonat;
	$counterGesamtW=$counterGesamt;
	$counterEinzelGesamtW=$counterEinzelGesamt;
	function ausgabeGesamt($zahl, $counterGesamt)
	{
		$c=0;
		if($counterGesamt!=0)
		{
			$c=floor($counterGesamt/$zahl);
		}
		return $c;
	}

	function ausgabeEinzel($zahl, $counterEinzel)
	{
		$c=array();
		for($i=0; $i<count($counterEinzel); $i++)
		{
			if($counterEinzel[$i]!=0)
			{
				$c[$i]=floor($counterEinzel[$i]/$zahl);
			}
			else
			{
				$c[$i]=0;
			}
		}	
		return $c;
	}

	function ausgabeAktuell($zahl, $counterAktuell)
	{
		$c=0;
		if($counterAktuell!=0)
		{
			$c=floor($counterAktuell/$zahl);
		}
		return $c;
	}
}

?>