<?php 

/*
============================================================
CMSimple Plugin CountDL
============================================================
Version:    CountDL 1.3
Released:   2024-03
Copyright:  Gert Ebersbach
Internet:   www.ge-webdesign.de
============================================================ 
utf-8 check: äöü 
*/

function dlcDlButton($file='',$showCounter='nocounter')
{
global $dlcListValue,$pth,$plugin_tx;

	$o = '
<div class="dlcButtonContainer">
<form action="./dlc-counter.php" method="post">
<input type="submit" name="dl-btn[' . $file . ']" class="dlcButtonDownloadFile" value="' . $plugin_tx['countdl']['text_button_download'] . ' ' . $file . '">
</form>
';

	$dlcFilesizeRaw = filesize('./userfiles/downloads/countdl/' . $file);
	if($dlcFilesizeRaw < 1000) $dlcFilesize = number_format($dlcFilesizeRaw,'0',',','.') . ' Byte';
	if($dlcFilesizeRaw >= 1000 && $dlcFilesizeRaw < 1000000) $dlcFilesize = number_format($dlcFilesizeRaw/1000,'0',',','.') . ' kByte';
	if($dlcFilesizeRaw >= 1000000 && $dlcFilesizeRaw < 1000000000) $dlcFilesize = number_format($dlcFilesizeRaw/1000000,'2',',','.') . ' MByte';
	if($dlcFilesizeRaw >= 1000000000 && $dlcFilesizeRaw < 1000000000000) $dlcFilesize = number_format($dlcFilesizeRaw/1000000000,'2',',','.') . ' GByte';

	$o.= '<span class="dlcButtonInfo">' . $dlcFilesize;

	if($showCounter == 'count' || $showCounter == 'counter')
	{
		$download=$file; 
		include($pth['folder']['base'] . 'plugins/countdl/dlc-countAusgabe.php'); 
		$o.= ' - ' . $plugin_tx['countdl']['text_button_number_of_downloads'] . ': ' . $dlcListValue;
	}

	$o.= '</span>
</div>
';

return $o ;
}



function dlcDlList($showCounter='nocounter',$dlfiles='all')
{
	global $dateiListe,$dlcListValue,$pth,$plugin_tx,$dlcDownload;

	$dlfiles = str_replace(', ',',',$dlfiles);
	$dlfiles = str_replace('&nbsp;','',$dlfiles);
	if($dlfiles!='all') $dateiListe = explode(',',$dlfiles);
	$o = '
<ul class="dlcList">';

	foreach($dateiListe as $dlcDownload)
	{
		$dlcDownload = trim($dlcDownload);
		if(($dlcDownload!=".") && ($dlcDownload!=".."))
		{
			$o.= '
<li>
<form action="./dlc-counter.php" method="post">
<input type="submit" name="dl-btn[' . $dlcDownload . ']" value="&dArr;&nbsp;' . $dlcDownload . '" title="Download ' . $dlcDownload . '" class="dlcListDownloadButton"> 
</form>
<span class="dlcListFile"><a href=""><span class="dlcListArrow">&dArr;</span>&nbsp;' . $dlcDownload . '</a></span>';

			$dlcFilesizeRaw = filesize('./userfiles/downloads/countdl/' . $dlcDownload);
			if($dlcFilesizeRaw < 1000) $dlcFilesize = number_format($dlcFilesizeRaw,'0',',','.') . ' Byte';
			if($dlcFilesizeRaw >= 1000 && $dlcFilesizeRaw < 1000000) $dlcFilesize = number_format($dlcFilesizeRaw/1000,'0',',','.') . ' kByte';
			if($dlcFilesizeRaw >= 1000000 && $dlcFilesizeRaw < 1000000000) $dlcFilesize = number_format($dlcFilesizeRaw/1000000,'2',',','.') . ' MByte';
			if($dlcFilesizeRaw >= 1000000000 && $dlcFilesizeRaw < 1000000000000) $dlcFilesize = number_format($dlcFilesizeRaw/1000000000,'2',',','.') . ' GByte';

			$o.= '&nbsp; <span class="dlcListInfo">' . $dlcFilesize;

			if($showCounter == 'count' || $showCounter == 'counter')
			{
				$download=$dlcDownload; 
				include($pth['folder']['base'] . 'plugins/countdl/dlc-countAusgabe.php');
				$o.= ' - ' . $plugin_tx['countdl']['text_button_number_of_downloads'] . ': ' . $dlcListValue;
			}

			$o.= '</span><div style="clear: both;"></div>
</li>
';
		}
	}

	$o.= '</ul>
<div style="clear: both;"></div>
';

	return $o;
}



function dlcDlTable($showCounter='nocounter',$dlfiles='all')
{
	global $dateiListe,$dlcListValue,$pth,$plugin_tx,$dlcDownload;

	$dlfiles = str_replace(', ',',',$dlfiles);
	$dlfiles = str_replace('&nbsp;','',$dlfiles);
	if($dlfiles!='all') $dateiListe = explode(',',$dlfiles);
	$o = '
<table class="dlcTable">';

	foreach($dateiListe as $dlcDownload)
	{
		$dlcDownload = trim($dlcDownload);
		if(($dlcDownload!=".") && ($dlcDownload!=".."))
		{
			$o.= '
<tr>';
			$o.= '
<td>
<form action="./dlc-counter.php" method="post">
<input type="submit" name="dl-btn[' . $dlcDownload . ']" value="&nbsp;" title="Download ' . $dlcDownload . '" class="dlcTableDownloadButton">
</form>
</td>
<td class="dlcTableFileAndInfo"><span class="dlcTableFile">' . $dlcDownload . '</span>';

			$dlcFilesizeRaw = filesize('./userfiles/downloads/countdl/' . $dlcDownload);
			if($dlcFilesizeRaw < 1000) $dlcFilesize = number_format($dlcFilesizeRaw,'0',',','.') . ' Byte';
			if($dlcFilesizeRaw >= 1000 && $dlcFilesizeRaw < 1000000) $dlcFilesize = number_format($dlcFilesizeRaw/1000,'0',',','.') . ' kByte';
			if($dlcFilesizeRaw >= 1000000 && $dlcFilesizeRaw < 1000000000) $dlcFilesize = number_format($dlcFilesizeRaw/1000000,'2',',','.') . ' MByte';
			if($dlcFilesizeRaw >= 1000000000 && $dlcFilesizeRaw < 1000000000000) $dlcFilesize = number_format($dlcFilesizeRaw/1000000000,'2',',','.') . ' GByte';

			$o.= '<br><span class="dlcTableInfo">' . $dlcFilesize;

			if($showCounter == 'count' || $showCounter == 'counter')
			{
				$download=$dlcDownload; 
				include($pth['folder']['base'] . 'plugins/countdl/dlc-countAusgabe.php');
				$o.= ' - ' . $plugin_tx['countdl']['text_button_number_of_downloads'] . ': ' . $dlcListValue;
			}

			$o.= '</span></td>
</tr>
';
		}
	}

	$o.= '
</table>
';

	return $o;
}
?>