<?php // utf-8 check: äöü

if (!function_exists('sv') || preg_match('#plugins/polls/index.php#i', $_SERVER['SCRIPT_NAME']))
{
	die('no direct access');
}

/*
============================================================
CMSimple Plugin Polls
============================================================
Version:    Polls 1.1
Released:   2023-01
Copyright:  Gert Ebersbach
Internet:   www.ge-webdesign.de
Credit:     mr-corner.com/LittlePoll/
============================================================ 
License: Commercial License (for commercial websites only)
see http://www.ge-webdesign.de/cmsimpleplugins/?Nutzungsbedingungen
============================================================ 
*/

function poll_iframe($pollFolder='_copytpl_de',$poll_iframe_heightPlus = NULL)
{
	global $hjs, $plugin_cf, $pth;
	
	// define data path
	if(is_dir('./content/plugins/polls/'))
	{
		$pathDataFolder = './' . $plugin_cf['polls']['path_polls'] . $pollFolder;
	}
	else
	{
		$pathDataFolder = $pth['folder']['base'] . $plugin_cf['polls']['path_polls'] . $pollFolder;
	}
	
	if(!defined('CMSIMPLE_VERSION'))
	{
		return '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="http://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
	}

	if(!$poll_iframe_heightPlus)
	{
		$poll_iframe_heightPlus = '36';
	}
	
	$poll_iframe_width = '100%';
	$poll_iframe_height = '220px';

	static $poll_iframeID = 0;
	$poll_iframeID++;
	
	$poll_iframeId = 'poll_iframe' . $poll_iframeID;



	$output = '
<script>
// <![CDATA[
function poll_iframe_resize_iframe_' . $poll_iframeId . '() 
{
	var poll_iframe_frame_height = document.getElementById("' . $poll_iframeId . '").contentWindow.document.body.offsetHeight + ' . $poll_iframe_heightPlus . ';
	document.getElementById("' . $poll_iframeId . '").style.height = (poll_iframe_frame_height + "px");
}
// ]]>
</script>
';

$output.= '
<iframe id="' . $poll_iframeId . '" onload="poll_iframe_resize_iframe_' . $poll_iframeId . '()" style="width: ' . $poll_iframe_width . '; height: ' . $poll_iframe_height . '; border: 0; padding: 0; margin: 0;" src="' . $pathDataFolder . '"></iframe>
';

return $output;
}

?>