<?php // utf-8 check: äöü

if (!defined('CMSIMPLE_VERSION') || preg_match('#plugins/polls/admin.php#i', $_SERVER['SCRIPT_NAME']))
{
	die('no direct access');
}

/*
============================================================
CMSimple Plugin Polls
============================================================
Version:    Polls 1.1
Released:   2023-01
Copyright:  Gert Ebersbach
Internet:   www.ge-webdesign.de
Credit:     mr-corner.com/LittlePoll/
============================================================ 
License: Commercial License (for commercial websites only)
see http://www.ge-webdesign.de/cmsimpleplugins/?Nutzungsbedingungen
============================================================ 
*/

initvar('polls');

if($polls)
{
	if(!defined('CMSIMPLE_VERSION'))
	{
		$o.= '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="http://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
		return;
	}
	
	if(defined('XH_ADM'))
	{
		$o.= '<div style="font-size: 15px; font-family: arial, sans-serif; letter-spacing: 0;">
<h4><a href="?polls">Plugin Info &raquo;</a></h4>
<p style="line-height: 1.6em;"><b>Polls</b>&nbsp;by&nbsp;<a href="http://www.ge-webdesign.de/cmsimpleplugins/"><u>ge-webdesign.de&nbsp;&raquo;</u></a> &nbsp; 
for&nbsp;<b>CMSimple&nbsp;4.0</b>&nbsp;or&nbsp;higher&nbsp;from&nbsp;<a href="http://www.cmsimple.org/"><u>cmsimple.org&nbsp;&raquo;</u></a></p>
</div>';
	}
	else
	{
		$o.= '<div style="font-size: 15px; font-family: arial, sans-serif; letter-spacing: 0; padding: 0 0 6px 0;">
<b><a href="?polls">Plugin Info &raquo;</a></b>
</div>
';
	}
	
	$plugin = 'polls';
	$o.= print_plugin_admin('on');
	
	if($admin=='')
	{
		$o.='
		<h4>Plugin Polls</h4>';
		
		$o .= '
		<div style="font-family: arial, sans-serif; font-size: 15px; letter-spacing: 0; border: 4px double; padding: 6px 16px; margin: 2px 0 8px 0;">
		<p style="text-align: center;">This Plugin is made for <a href="http://www.cmsimple.org/"><span style="font-weight: 700; padding: 0 6px; ">CMSimple 4.2 &raquo;</span></a> or higher.</p>
		<p style="text-align: center;">Optimized for <span style="font-weight: 700; padding: 0 6px; ">CMSimple 4.4</span> or higher.</p>
		<p style="text-align: center;">Recommended is the current version of CMSimple from <a href="http://www.cmsimple.org/">cmsimple.org&nbsp;&raquo;</a></p>
		</div>
		';
		
		$o.='<ul>
		<li>Version: Polls 1.1</li>
		<li>Released: 2023-01</li>
		<li>Copyright: Gert Ebersbach</li>
		<li>Internet: <a href="http://www.ge-webdesign.de/cmsimpleplugins/?Eigene_Plugins">www.ge-webdesign.de</a></li>
		<li>Credit: Inspired by <a href="http://www.mr-corner.com/LittlePoll/">LittlePoll</a></li>
		<li>Lizenz: <a href="http://www.ge-webdesign.de/cmsimpleplugins/?Nutzungsbedingungen">Commercial License</a> for commercial websites</li>
		</ul>
		';
	}
	
	if($admin=='plugin_main')
	{
		if(file_exists($pth['folder']['templates'].'__cmsimple_backend__/template.htm'))
		{
			$pth['folder']['template'] = $pth['folder']['templates'].'__cmsimple_backend__/';
			$pth['file']['template'] = $pth['folder']['template'].'template.htm';
			$pth['file']['stylesheet'] = $pth['folder']['template'].'stylesheet.css';
			$pth['folder']['menubuttons'] = $pth['folder']['template'].'menu/';
			$pth['folder']['templateimages'] = $pth['folder']['template'].'images/';
			$cf['meta']['robots'] = 'noindex, nofollow';
		}
		
		// define data path
		if(is_dir('./content/plugins/polls/'))
		{
			$pollDataPath = './' . $plugin_cf['polls']['path_polls'];
		}
		else
		{
			$pollDataPath = $pth['folder']['base'] . $plugin_cf['polls']['path_polls'];
		}
		
		// create polls array
		if($pollPollsHandle = opendir($pollDataPath))
		{
			while($pollPoll = readdir($pollPollsHandle))
			{
				if($pollPoll != '.' && $pollPoll != '..')
				{
					$pollPolls[] = str_replace('.php','',$pollPoll);
					natcasesort($pollPolls);
				}
			}
		} 
		
		if(isset($_POST['pollSelectedPoll']) && $_POST['pollSelectedPoll'] != '')
		{
			unset($_SESSION['poll_active_poll']);
			$_SESSION['poll_active_poll'] = $_POST['pollSelectedPoll'];
		}
		
		if(isset($_POST['pollSelectedPoll']) && $_POST['pollSelectedPoll'] == $plugin_tx['polls']['text_select_poll'])
		{
			unset($_SESSION['poll_active_poll']);
		}
		
		$o.='<p><b>Polls - ' . $plugin_tx['polls']['menu_main'] . '</b></p>';


/* 
#####################################
        begin backend output
##################################### 
*/

		if(isset($_POST['pollNewPollDirname']) || isset($_POST['pollWriteSettings']))csrfProtection();

		if(!isset($_POST['pollNewPollDirname']) && !isset($_GET['pollDeletePoll']))
		{
			// polls selectbox
			if(!isset($_SESSION['poll_active_poll']))
			{
				$o.='<p>' . $plugin_tx['polls']['text_newpoll_hint'] . '</p>' . "\n";
			}
			
			$o.='<form method="post" action="?polls&admin=plugin_main&action=plugin_text&amp;pollSelectedPoll">' . "\n";
			$o.='<input type="hidden" name="csrf_token" value="' . $_SESSION[$csrfSession] . '">' . "\n";
			$o.='<select name="pollSelectedPoll" onchange="this.form.submit()" style="border: 2px solid #999; padding: 2px;">' . "\n";
			$o.='<option style="padding: 0 6px;">' . $plugin_tx['polls']['text_select_poll'] . '</option>' . "\n";
			
			foreach ($pollPolls as $pollSelectedPoll)
			{
				if(isset($_SESSION['poll_active_poll']) && $pollSelectedPoll == $_SESSION['poll_active_poll'])
				{
					$o.='<option selected="selected" style="padding: 0 6px;" value="' . $pollSelectedPoll . '">' . $pollSelectedPoll . '</option>' . "\n";
				}
				else
				{
					$o.='<option style="padding: 0 6px;" value="' . $pollSelectedPoll . '">' . $pollSelectedPoll . '</option>' . "\n";
				}
			}
			$o.='</select>' . "\n";
			$o.='</form>' . "\n";
		
		
			// message selected poll
			if
			(
				!isset($_SESSION['poll_active_poll']) || 
				isset($_POST['pollSelectedPoll']) && $_POST['pollSelectedPoll'] == $plugin_tx['polls']['text_select_poll'] || 
				$_SESSION['poll_active_poll'] == $plugin_tx['polls']['text_select_poll']
			)
			{
				$o .='<p class="poll_admin_no_poll_selected">' . $plugin_tx['polls']['text_nopoll'] . '</p>' . "\n";
			}
			else
			{
				$o .='<p class="poll_admin_selected_poll">' . $plugin_tx['polls']['message_active_poll1'] . '<span style="font-size: 20px;">&nbsp;&nbsp;' . $_SESSION['poll_active_poll'] . '&nbsp;&nbsp;</span>' . $plugin_tx['polls']['message_active_poll2'] . '</p>' . "\n";
			}
		}
		
		$o .='<br style="clear: both;">';
		
		
		if(isset($_SESSION['poll_active_poll']))
		{
			if(!isset($_POST['pollNewPollDirname']) && !isset($_GET['pollDeletePoll']) && !isset($_GET['poll_write_data']) && !isset($_REQUEST['poll_write_iplist']))
			{
				if(isset($_POST['pollNewPollDirname']))csrfProtection();
				
				// form create new poll
				$o.= '<h4>' . $plugin_tx['polls']['headline_create_new_poll'] . '</h4>
	<p>' . $plugin_tx['polls']['text_create_new_poll'] . '</p>
	<form method="post" action="' . $sn . '?polls&admin=plugin_main&action=plugin_text&poll_create_poll=done&securityCode=' . $_SESSION[$csrfSession] . '">
	<p>' . $plugin_tx['polls']['text_poll_filename'] . '</p>
	<input type="hidden" name="csrf_token" value="' . $_SESSION[$csrfSession] . '">' . "\n" . '
	<input type="text" name="pollNewPollDirname" style="float: left; width: 200px; font-family: arial, sans-serif; border: 1px solid #999; padding: 3px 6px;">
	<input type="submit" class="submit" value="' . $plugin_tx['polls']['button_create_poll'] . '">
	</form>';
			
			
				// link to delete poll
				if($plugin_cf['polls']['allow_delete_polls'] == 'true')
				{
					$o.= '<h4>' . $plugin_tx['polls']['headline_delete_poll'] . '</h4>
<p><a href="./?polls&admin=plugin_main&action=plugin_text&pollDeletePoll&securityCode=' . $_SESSION[$csrfSession] . '" onClick="return confirm(\'' . $plugin_tx['polls']['text_confirm_delete_poll1'] . ' &nbsp; &quot;' . $_SESSION['poll_active_poll'] . '&quot; &nbsp; ' . $plugin_tx['polls']['text_confirm_delete_poll2'] . '\')">' . $plugin_tx['polls']['text_delete_poll1'] . ' <b>"' . $_SESSION['poll_active_poll'] . '"</b> ' . $plugin_tx['polls']['text_delete_poll2'] . ' &raquo;</a></p>
';
				}
			}
			
			// textarea data file
			if(!isset($_REQUEST['poll_write_iplist']) && !isset($_REQUEST['poll_write_data']) && !isset($_REQUEST['poll_create_poll'])  && !isset($_REQUEST['pollDeletePoll']))
			{
				$o .='
<hr>
<h4>' . $plugin_tx['polls']['headline_edit_poll'] . '</h4>
<form method="post" action="' . $sn . '?polls&admin=plugin_main&action=plugin_text&poll_write_data=done">' . "\n" . '
<input type="hidden" name="csrf_token" value="' . $_SESSION[$csrfSession] . '">' . "\n" . '
<input type="submit" class="submit" style="margin-bottom: 12px;" value="' . $plugin_tx['polls']['button_save'] . '">
<p><b>' . $plugin_tx['polls']['headline_edit_settings'] . '</b></p>
<textarea type="text" class="pollBackendDatafile" name="pollWriteSettings">' . file_get_contents($pollDataPath . $_SESSION['poll_active_poll'] . '/poll_settings.php') . '</textarea><br>' . "\n" . '
<p><b>' . $plugin_tx['polls']['headline_edit_data'] . '</b></p>
<p>' . $plugin_tx['polls']['text_data_line1'] . '</p>
<p style="font-family: courier new, monospace;">' . $plugin_tx['polls']['text_data_line2'] . '</p>
<p>' . $plugin_tx['polls']['text_no_empty_lines'] . '</p>
<textarea type="text" class="pollBackendDatafile" name="pollWriteData">' . file_get_contents($pollDataPath . $_SESSION['poll_active_poll'] . '/poll_data.txt') . '</textarea><br>' . "\n" . '
<input type="submit" class="submit" value="' . $plugin_tx['polls']['button_save'] . '">
</form>' . "\n";
			}
		}
		
		// show active poll
		if(!isset($_REQUEST['poll_write_iplist']) && !isset($_REQUEST['poll_write_data']) && !isset($_REQUEST['poll_create_poll'])  && !isset($_REQUEST['pollDeletePoll']) && isset($_SESSION['poll_active_poll']))
		{
			$o .='
<hr>
<div style="width: 60%; min-width: 320px; max-width: 600px; float: left; padding-right: 36px;">
' . poll_iframe($_SESSION['poll_active_poll']) . '
</div>
';
		}

		// textarea ip list
		if(!isset($_REQUEST['poll_write_iplist']) && !isset($_REQUEST['poll_write_data']) && !isset($_REQUEST['poll_create_poll'])  && !isset($_REQUEST['pollDeletePoll']) && isset($_SESSION['poll_active_poll']))
		{
			$o .='
<hr>
<h4>' . $plugin_tx['polls']['headline_edit_iplist'] . '</h4>
<form method="post" action="' . $sn . '?polls&admin=plugin_main&action=plugin_text&poll_write_iplist=done">' . "\n" . '
<input type="submit" class="submit" value="' . $plugin_tx['polls']['button_save'] . '">
<input type="hidden" name="csrf_token" value="' . $_SESSION[$csrfSession] . '">' . "\n" . '
<textarea type="text" class="pollBackendDatafile" name="pollWriteIplist">' . file_get_contents($pollDataPath . $_SESSION['poll_active_poll'] . '/poll_iplist.txt') . '</textarea><br>' . "\n" . '
<input type="submit" class="submit" value="' . $plugin_tx['polls']['button_save'] . '">
</form>' . "\n";
		}




/* 
#####################################
          write files
##################################### 
*/

		if(isset($_POST['pollWriteSettings']))
		{
			if(!is_writeable($pollDataPath . $_SESSION['poll_active_poll'] . '/poll_settings.php'))
			{
				die('<p>The file</p><p style="font-family: courier new, monospace; font-weight: 700;">' . $pollDataPath . $_SESSION['poll_active_poll'] . '/poll_settings.php' . '</p><p>is not writeable, please check the writing permissions of the file.</p>');
			}
			else
			{
				$pollSettingsFile = fopen($pollDataPath . $_SESSION['poll_active_poll'] . '/poll_settings.php', 'w+');
				ftruncate($pollSettingsFile, 0);
				$pollSettingsfileContent=$_POST['pollWriteSettings'];
				fwrite($pollSettingsFile, $pollSettingsfileContent);
				fclose($pollSettingsFile);
			}
		}
		
		if(isset($_POST['pollWriteData']))
		{
			if(!is_writeable($pollDataPath . $_SESSION['poll_active_poll'] . '/poll_data.txt'))
			{
				die('<p>The file</p><p style="font-family: courier new, monospace; font-weight: 700;">' . $pollDataPath . $_SESSION['poll_active_poll'] . '/poll_data.txt' . '</p><p>is not writeable, please check the writing permissions of the file.</p>');
			}
			else
			{
				$pollDataFile = fopen($pollDataPath . $_SESSION['poll_active_poll'] . '/poll_data.txt', 'w+');
				ftruncate($pollDataFile, 0);
				$pollDatafileContent=$_POST['pollWriteData'];
				fwrite($pollDataFile, $pollDatafileContent);
				fclose($pollDataFile);
			}
		}
		
		if(isset($_POST['pollWriteIplist']))
		{
			if(!is_writeable($pollDataPath . $_SESSION['poll_active_poll'] . '/poll_iplist.txt'))
			{
				die('<p>The file</p><p style="font-family: courier new, monospace; font-weight: 700;">' . $pollDataPath . $_SESSION['poll_active_poll'] . '/poll_iplist.txt' . '</p><p>is not writeable, please check the writing permissions of the file.</p>');
			}
			else
			{
				$pollIplistFile = fopen($pollDataPath . $_SESSION['poll_active_poll'] . '/poll_iplist.txt', 'w+');
				ftruncate($pollIplistFile, 0);
				$pollIplistfileContent=$_POST['pollWriteIplist'];
				fwrite($pollIplistFile, $pollIplistfileContent);
				fclose($pollIplistFile);
			}
		}
		
/* 
#####################################
     create and delete polls
##################################### 
*/
		
		if(isset($_GET['poll_create_poll']) && isset($_POST['pollNewPollDirname']) && $_POST['pollNewPollDirname'] != '')
		{
			if(is_dir($pollDataPath . $_POST['pollNewPollDirname']))
			{
				$o.='<p class="cmsimplecore_warning" style="text-align: center; font-weight: 700; line-height: 2em;">' . $plugin_tx['polls']['message_poll_already_exits'] . '</p><br>
<p style="text-align: center;">
<a href="./?polls&admin=plugin_main&action=plugin_text">' . $plugin_tx['polls']['message_back_mainfuncs'] . '</a></p>';
				return;
			}
			else
			{
				if($_GET['securityCode'] == $_SESSION[$csrfSession])
				{
					mkdir($pollDataPath . $_POST['pollNewPollDirname'],0777);
					copy($pollDataPath . $_SESSION['poll_active_poll'] . '/index.php',$pollDataPath . $_POST['pollNewPollDirname'] . '/index.php');
					chmod($pollDataPath . $_POST['pollNewPollDirname'] . '/index.php', 0666);
					copy($pollDataPath . $_SESSION['poll_active_poll'] . '/poll_settings.php',$pollDataPath . $_POST['pollNewPollDirname'] . '/poll_settings.php');
					chmod($pollDataPath . $_POST['pollNewPollDirname'] . '/poll_settings.php', 0666);
					copy($pollDataPath . $_SESSION['poll_active_poll'] . '/poll_source.php',$pollDataPath . $_POST['pollNewPollDirname'] . '/poll_source.php');
					chmod($pollDataPath . $_POST['pollNewPollDirname'] . '/poll_source.php', 0666);
					copy($pollDataPath . $_SESSION['poll_active_poll'] . '/poll_iplist.txt',$pollDataPath . $_POST['pollNewPollDirname'] . '/poll_iplist.txt');
					chmod($pollDataPath . $_POST['pollNewPollDirname'] . '/poll_iplist.txt', 0666);
					copy($pollDataPath . $_SESSION['poll_active_poll'] . '/poll_data.txt',$pollDataPath . $_POST['pollNewPollDirname'] . '/poll_data.txt');
					chmod($pollDataPath . $_POST['pollNewPollDirname'] . '/poll_data.txt', 0666);
				}
				else
				{
					die("<a href=\"./?logout\">CSRF protection - logout &raquo;</a>");
				}
			}
		}
		
		if(isset($_GET['pollDeletePoll']))
		{
			if($_GET['securityCode'] == $_SESSION[$csrfSession])
			{
				unlink($pollDataPath . $_SESSION['poll_active_poll'] . '/index.php');
				unlink($pollDataPath . $_SESSION['poll_active_poll'] . '/poll_settings.php');
				unlink($pollDataPath . $_SESSION['poll_active_poll'] . '/poll_source.php');
				unlink($pollDataPath . $_SESSION['poll_active_poll'] . '/poll_iplist.txt');
				unlink($pollDataPath . $_SESSION['poll_active_poll'] . '/poll_data.txt');
				rmdir($pollDataPath . $_SESSION['poll_active_poll']);
				unset($_SESSION['poll_active_poll']);
			}
			else
			{
				die("<a href=\"./?logout\">CSRF protection - logout &raquo;</a>");
			}
		}
		
		
/* 
#####################################
     success messages
##################################### 
*/

		// success message updated data
		if(isset($_REQUEST['poll_write_data']) && $_REQUEST['poll_write_data'] == 'done')
		{
			$o.= '<p class="cmsimplecore_warning" style="text-align: center; font-weight: 700; line-height: 2em;">' . $plugin_tx['polls']['message_updated'] . '</p><br>';
			$o.= '<p style="text-align: center;">
<a href="./?polls&admin=plugin_main&action=plugin_text">' . $plugin_tx['polls']['message_back_mainfuncs'] . '</a></p>
<p style="text-align: center;">
';
		}
		
		// success message updated IPlist
		if(isset($_REQUEST['poll_write_iplist']) && $_REQUEST['poll_write_iplist'] == 'done')
		{
			$o.= '<p class="cmsimplecore_warning" style="text-align: center; font-weight: 700; line-height: 2em;">' . $plugin_tx['polls']['message_updated'] . '</p><br>';
			$o.= '<p style="text-align: center;">
<a href="./?polls&admin=plugin_main&action=plugin_text">' . $plugin_tx['polls']['message_back_mainfuncs'] . '</a></p>
<p style="text-align: center;">
';
		}
		
		// success message created poll
		if(isset($_REQUEST['poll_create_poll']) && $_REQUEST['poll_create_poll'] == 'done')
		{
			if(isset($_POST['pollNewPollDirname']) && $_POST['pollNewPollDirname'] != '')
			{
				$o.= '<p class="cmsimplecore_warning" style="text-align: center; font-weight: 700; line-height: 2em;">' . $plugin_tx['polls']['message_poll_created'] . '</p><br>';
				$o.= '<p style="text-align: center;">
<a href="./?polls&admin=plugin_main&action=plugin_text">' . $plugin_tx['polls']['message_back_mainfuncs'] . '</a></p>
<p style="text-align: center;">
';
			$_SESSION['poll_active_poll'] = $_POST['pollNewPollDirname'];
			}
			else
			{
				$o.= '<p class="cmsimplecore_warning" style="text-align: center; font-weight: 700; line-height: 2em;">' . $plugin_tx['polls']['message_no_poll_created'] . '</p><br>';
				$o.= '<p style="text-align: center;">
<a href="./?polls&admin=plugin_main&action=plugin_text">' . $plugin_tx['polls']['message_back_mainfuncs'] . '</a></p>
<p style="text-align: center;">
';
			}
		}
		
		// success message dleted poll
		if(isset($_REQUEST['pollDeletePoll']))
		{
			$o.= '<p class="cmsimplecore_warning" style="text-align: center; font-weight: 700; line-height: 2em;">' . $plugin_tx['polls']['message_poll_deleted'] . '</p><br>';
			$o.= '<p style="text-align: center;">
<a href="./?polls&admin=plugin_main&action=plugin_text">' . $plugin_tx['polls']['message_back_mainfuncs'] . '</a></p>
<p style="text-align: center;">
';
		}
	}

	if ($admin <> 'plugin_main') 
	{
		$hint=array();
		$hint['mode_donotshowvarnames'] = false;
		$o.=plugin_admin_common($action, $admin, $plugin, $hint);
	}
}

?>