<?php
/* utf8-marker = äöü */

if (!function_exists('sv') || preg_match('#plugins/langmenup2p/index.php#i', $_SERVER['SCRIPT_NAME']))
{
	die('no direct access');
}

/*
============================================================
CMSimple Plugin LanguageMenuP2P
============================================================
Version:    LanguageMenuP2P 1.5
Released:   2023-01
Copyright:  Gert Ebersbach - www.ge-webdesign.de
============================================================ 
License:
- free for noncommercial websites
- fee required for commercial websites
============================================================ 
Credits:
Many thanks to Jesper Zedlitz for the basic code and idea.
http://www.zedlitz.de/?Software:CMSimple-Plugins
============================================================ 
*/

if(defined('CMSIMPLE_VERSION'))
{
	$pd_router -> add_interest('unified_name');
	$pd_router -> add_tab('lmP2P', $pth['folder']['plugins'].'langmenup2p/langmenup2p_view.php');
}

if(file_exists('./cmsimplelanguage.htm'))
{
	$lm2BasePath = '../';
}
else
{
	$lm2BasePath = './';
}

// link only to existing pages in other languages (needs "unified_name" page property) - by jzedlitz 2011-01-08
function lmp2p() 
{
	global $pth, $cf, $sl, $s , $u, $pd_current, $lm2BasePath;
	
	if(!defined('CMSIMPLE_VERSION'))
	{
		return '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="http://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
	}
	
	$t = '';
	$r = array();
	$fd = opendir($lm2BasePath);
	while (($p = readdir($fd)) == true ) 
	{
		if (is_dir($lm2BasePath . $p) && file_exists($lm2BasePath . $p . '/' . 'cmsimplelanguage.htm') && $p != "2lang" && $p != "2site2lang")
		{
			$r[] = $p;
		}
	}
	if(isset($pd_current['unified_name']))$unified_name = $pd_current['unified_name']; else $unified_name = '';
	if($unified_name == '') return '';

	if ($fd == true)closedir($fd); 
	if(count($r) == 0)return ''; 
	if($cf['language']['default'] != $sl) 
	{
		$t .= lmp2p_find_page('', $unified_name );
	}
	$v = count($r); 
	for($i = 0;$i < $v;$i++) 
	{
		if ($sl != $r[$i]) 
		{
		    $t .= lmp2p_find_page($r[$i], $unified_name );
		}
	}
	$t.= "\n";

	return ''.$t.'';
}
// END new function lmp2p()

function lmp2p_find_page($language,$unified_name) 
{
	global $pth, $cf, $lm2BasePath;
	
	$lang_short_temp = explode(",", $cf['language']['short']);
	foreach($lang_short_temp as $lang_short_element){$lang_short[] = '|' . $lang_short_element . '|';}
	$lang_long = explode(",", stripslashes(strip_tags($cf['language']['long'])));
    
	$t = '';
    
	include($lm2BasePath . $language . '/content/pagedata.php');

	foreach( $page_data as $p_id => $page ) 
	{
		if( isset($page['unified_name']) && $page['unified_name'] == $unified_name ) 
		{
			$u = lmp2p_read_menu($language);

			if( $language == '' ) 
			{
				$url = $lm2BasePath . '?' . $u[$p_id];
				$flag = $pth['folder']['flags'].'/'.$cf['language']['default'].'.gif';
				$lang2 = $cf['language']['default'];
			} 
			else 
			{
				$url = $lm2BasePath . $language . '/?' . $u[$p_id];
				$flag = $pth['folder']['flags'] . '/' . $language . '.gif';
				$lang2 = $language;
			}
			
			if (is_file($flag)) 
			{
				$t = "\n" . '<a href="' . $url . '"><img src="'.$flag.'" alt="'.$language.'" title="&nbsp;' . str_replace('|','',str_replace($lang_short,$lang_long,'|' . $lang2 . '|')) . '&nbsp;" class="flag"></a> ';
			} 
			else 
			{
				$t = "\n" . '<a href="' . $url . '"><span class="cmsimple_language_menuitem">' . str_replace('|','',str_replace($lang_short,$lang_long,'|' . $lang2 . '|')) . '</span></a> ';
			}
		}
	}

	return $t;
}

// This is basicly a copy of the "rfc" function.
function lmp2p_read_menu($language) 
{
	global $pth, $cf, $lm2BasePath;
	  
	$u = array();
	$l = array();
	$empty = 0;
	$duplicate = 0;
	
	// define content file
	if (file_exists('./content/content.php'))
	{
		$lmp2p_contentfile = 'content.php';
	}
	else
	{
		$lmp2p_contentfile = 'content.htm';
	}

	$content = file_get_contents($lm2BasePath . $language . '/content/' . $lmp2p_contentfile);
	$stop = $cf['menu']['levels'];
	$split_token = '#@CMSIMPLE_SPLIT@#';

	$content = preg_split('~</body>~i', $content);
//	$content = preg_replace('~<h[1-' . $stop . ']~i', $split_token . '$0', $content[0]);
	
	if($cf['use']['h1only_pagesplitting'] == 'true')
	{
		$content = preg_replace('~<h1.*?class=".*?_level([1-6])_page_~i', $split_token . '$0', $content[0]);
	}
	else
	{
		$content = preg_replace('~<h[1-' . $stop . ']~i', $split_token . '$0', $content[0]);
	}
	
	$content = explode($split_token, $content);
	array_shift($content);

	foreach ($content as $page) 
	{
		if($cf['use']['h1only_pagesplitting'] == 'true')
		{
			preg_match('~<h1.*?class=".*?_level([1-6])_page_.*>(.*)</h~isU', $page, $temp);
		}
		else
		{
			preg_match('~<h([1-' . $stop . ']).*>(.*)</h~isU', $page, $temp);
		}

		$l[] = $temp[1];
		$temp_h[] = trim(strip_tags($temp[2]));
	}

	$ancestors = array(); 
	foreach ($temp_h as $i => $heading) 
	{
		$temp = trim(strip_tags($heading));
		if ($temp == '') 
		{
			$empty++;
			$temp = $tx['toc']['empty'] . ' ' . $empty;
		}
		$ancestors[$l[$i] - 1] = uenc($temp);
		$ancestors = array_slice($ancestors, 0, $l[$i]);
		$url = implode($cf['uri']['seperator'], $ancestors);
		$u[] = substr($url, 0, $cf['uri']['length']);
	}

	return $u;
}

?>