<?php
/*utf-8 check: äöü */

if (!function_exists('sv') || preg_match('#plugins/langmenup2p/admin.php#i', $_SERVER['SCRIPT_NAME']))
{
	die('no direct access');
}

/*
============================================================
CMSimple Plugin LanguageMenuP2P
============================================================
Version:    LanguageMenuP2P 1.5
Released:   2023-01
Copyright:  Gert Ebersbach - www.ge-webdesign.de
============================================================ 
License:
- free for noncommercial websites
- fee required for commercial websites
============================================================ 
Credits:
Many thanks to Jesper Zedlitz for the basic code and idea.
http://www.zedlitz.de/?Software:CMSimple-Plugins
============================================================ 
*/

initvar('langmenup2p');
if ($langmenup2p) 
{
	if(!defined('CMSIMPLE_VERSION'))
	{
		$o.= '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="http://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
		return;
	}
	
	if(defined('XH_ADM'))
	{
		$o.= '<div style="font-size: 15px; font-family: arial, sans-serif; letter-spacing: 0;">
<h4><a href="?langmenup2p">Plugin Info &raquo;</a></h4>
<p style="line-height: 1.6em;"><b>LanguageMenuP2P</b>&nbsp;by&nbsp;<a href="http://www.ge-webdesign.de/cmsimpleplugins/"><u>ge-webdesign.de&nbsp;&raquo;</u></a> &nbsp; 
for&nbsp;<b>CMSimple&nbsp;4.2</b>&nbsp;or&nbsp;higher&nbsp;from&nbsp;<a href="http://www.cmsimple.org/"><u>cmsimple.org&nbsp;&raquo;</u></a></p>
</div>';
	}
	else
	{
		$o.= '<div style="font-size: 15px; font-family: arial, sans-serif; letter-spacing: 0; padding: 0 0 6px 0;">
<b><a href="?langmenup2p">Plugin Info &raquo;</a></b>
</div>
';
	}
	
	// Make CMSimple variables accessible
	global $sn,$sl,$pth,$cf,$plugin,$plugin_tx,$lm2BasePath;
	
	
	// Detect the foldername of the plugin.
	$plugin=basename(dirname(__FILE__),"/");

	// Parameter "ON"  shows the Plugin Main Tab.
	// Blank "" or "OFF" does not show the Plugin Main Tab.
	$o.=print_plugin_admin('ON');
	
	$o.= '<br>';
	
	// First page when loading the plugin.
	
	if ($admin == '') 
	{
		$o.= '<h4>LangMenuP2P 1.5</h4>
<div style="font-family: arial, sans-serif; font-size: 15px; letter-spacing: 0; border: 4px double; padding: 6px 16px; margin: 2px 0 8px 0;">
<p style="text-align: center;">This Plugin is made for <a href="http://www.cmsimple.org/"><span style="font-weight: 700; padding: 0 6px; ">CMSimple 4.5 &raquo;</span></a> or higher.</p>
<p style="text-align: center;">Recommended is the current version of CMSimple from <a href="http://www.cmsimple.org/">cmsimple.org&nbsp;&raquo;</a></p>
</div>
';
		
		$o .= '
<p><b>Version: </b>1.5</p>
<p><b>Developed by: </b><a href="http://www.ge-webdesign.de/cmsimpleplugins/">ge-webdesign.de</a></p>
<p><b>Released: </b>2023-01</p>
<p><b>Credit:</b></p>
<p>LangMenuP2P is based on the MultiLang Plugin, many thanks to <a href="http://www.zedlitz.de/?Software:CMSimple-Plugins" target="_blank">Jesper Zedlitz</a> for the basic code and idea.</p>
<hr />
<p><b>Licenses:</b></p>
<ul>
<li>Freeware License (private websites)</li>
<li>Commercial License (commercial websites - for costs)</li>
</ul>
<p><b>For License Prices see: </b><a href="http://www.ge-webdesign.de/cmsimpleplugins/">ge-webdesign.de</a><br />';
	}
	
	
	if ($admin == 'plugin_main') 
	{
		// activate backend template, if exists
		if(file_exists($pth['folder']['templates'].'__cmsimple_backend__/template.htm'))
		{
			$pth['folder']['template'] = $pth['folder']['templates'].'__cmsimple_backend__/';
			$pth['file']['template'] = $pth['folder']['template'].'template.htm';
			$pth['file']['stylesheet'] = $pth['folder']['template'].'stylesheet.css';
			$pth['folder']['menubuttons'] = $pth['folder']['template'].'menu/';
			$pth['folder']['templateimages'] = $pth['folder']['template'].'images/';
			$cf['meta']['robots'] = 'noindex, nofollow';
		}

		// create a list of available languages
		$r = array();
		$fd = opendir($lm2BasePath);
		while (($p = readdir($fd)) == true ) 
		{
			if (is_dir($lm2BasePath . $p)) 
			{
				if (file_exists($lm2BasePath . $p . '/' . 'cmsimplelanguage.htm') && $p != "2lang" && $p != "2site2lang")
				{
					$r[] = $p;
				}
			}
		}
		
		$lang_list = $r;

		// collect unified_names for all languages
		$names = array();
		foreach($lang_list as $lang ) 
		{
			include($lm2BasePath.$lang.'/content/pagedata.php');
			foreach( $page_data as $i => $page ) 
			{
				$names[$lang][$i] = $page['unified_name'];
			}
		}
 
		// add the default language
		include($lm2BasePath.'/content/pagedata.php');
		foreach( $page_data as $i => $page ) 
		{
			$names[$cf['language']['default']][$i] = $page['unified_name'];
		}
		array_splice($lang_list, 0, 0, $cf['language']['default']);

	    // reset page_data
	    include('content/pagedata.php');

		$o.='<table class="lmp2p_table">' . "\n" . 
		'<tr>
<th>'.$tx['search']['pgsingular'].' <img src="'.$pth['folder']['flags'].'/'.$sl.'.gif'.'" alt="'.$sl.'" title="&nbsp;'.$sl.'&nbsp;" class="flag"></th>
<th>'.$plugin_tx['langmenup2p']['cf_unified_name'].'</th>
';
		
		// table header
		foreach($lang_list as $lang ) 
		{
			if( $lang != $sl ) 
			{
				$o .= '<th>' . "\n";
				if( $lang == $cf['language']['default'] ) 
				{
					$o .= '<a href="'.$lm2BasePath.'?&amp;langmenup2p&amp;normal">';
					$o .= '<img src="'.$pth['folder']['flags'].'/'.$lang.'.gif'.'" alt="'.$lang.'" title="&nbsp;'.$lang.'&nbsp;" class="flag">';
					$o .= '</a> (default)';
				} 
				else 
				{
					$o .= '<a href="'.$lm2BasePath.$lang.'/?&amp;langmenup2p&amp;normal">';
					$o .= '<img src="'.$pth['folder']['flags'].'/'.$lang.'.gif'.'" alt="'.$lang.'" title="&nbsp;'.$lang.'&nbsp;" class="flag">';
					$o .= '</a>';
				}
				$o .= '</th>' . "\n";
			}
		}
		$o .= '</tr>' . "\n\n";
		
		// process all pages
		foreach( $h as $id => $title ) 
		{
			$clearPageLocator = str_replace('%26amp%3B','&',$u[$id]);
			$clearPageLocator = str_replace('___','&nbsp; &nbsp;&raquo;&nbsp; &nbsp;',$clearPageLocator);
			$clearPageLocator = str_replace('_',' ',$clearPageLocator);
			
			$unified_name = $page_data[$id]['unified_name'];
			$o .= '<tr>
<td>' . a($id,null) . urldecode($clearPageLocator) . '</a></td>' . "\n";
			if( $unified_name ) 
			{
				$o .= '<td>'.$unified_name.'</td>' . "\n";
				// all other languages
				foreach($lang_list as $lang ) 
				{
					if( $lang != $sl ) 
					{
						$o .= '<td>' . "\n";
						
						if( in_array($unified_name, $names[$lang]) ) 
						{
							$o .= 'ok';
						}
						$o .= '</td>' . "\n";
					}
				}
			}
			$o .= '</tr>' . "\n\n";
		}
		
		$o.='</table>' . "\n";
	} 

	if ($admin != 'plugin_main') 
	{
		$hint=array();
		$hint['mode_donotshowvarnames'] = false;
		$o.=plugin_admin_common($action, $admin, $plugin, $hint);
	}
}
?>