<?php // utf-8 check: äöü

if (!function_exists('sv') || preg_match('#plugins/membersarea/index.php#i', $_SERVER['SCRIPT_NAME']))
{
	die('no direct access');
}

/*
============================================================
CMSimple Plugin MembersArea
============================================================
Version:    MembersArea 2.9
Released:   2023-01
Copyright:  Gert Ebersbach
Internet:   www.ge-webdesign.de
============================================================ 
License: Commercial License (for commercial websites only)
see http://www.ge-webdesign.de/cmsimpleplugins/?Nutzungsbedingungen
============================================================ 
*/

if(!function_exists('rfc')){die('access denied');}
if(!isset($_SESSION)){session_start();}

define('MEMBERSAREA_VERSION', '2.9');
header("Cache-Control: no-cache, must-revalidate");

// define data file

if(file_exists('./' . $plugin_cf['membersarea']['data_path_user']))
{
	$mapl_data_file = './' . $plugin_cf['membersarea']['data_path_user'];
}
else
{
	$mapl_data_file = $pth['folder']['base'] . $plugin_cf['membersarea']['data_path_user'];
}

// create users array (for login only)

$members_array = file($mapl_data_file);

//print_r($members_array);

//print_r($members_array);

/*
if(isset($_POST['mapl_logout_page']))
{
	if(isset($_POST['mapl_logout']))
	{
		header('Location: ' . $sn . '?' . $mapl_logout_page);
	}
}
*/

/*
########################
   MEMBERSAREA LOGIN
########################
*/

if
(
	isset($_POST['mapl_username']) && 
	isset($_POST['mapl_password']) && 
	$_POST['mapl_username'] != '' && 
	$_POST['mapl_password'] != '' && 
	strstr(file_get_contents($mapl_data_file), '-- --' . $_POST['mapl_username'] . '-- --' . md5($plugin_cf['membersarea']['md5_before'] . $_POST['mapl_password'] . $plugin_cf['membersarea']['md5_after']) . '-- --') 
)
{
// find out the group of the user and init some variables (for login only)
	foreach($members_array as $member)
	{
		if(strstr($member, '-- --' . $_POST['mapl_username'] . '-- --'))
		{
			$member = explode('-- --',$member);
			$malogin_fullname = $member[0];
			$malogin_group = str_replace('|||','',$member[3]);
			$malogin_email = $member[4];
			if(isset($member[5])) $malogin_invoice_addr = $member[5];
			if(isset($member[6])) $malogin_delivery_addr = $member[6];
		}
	}




// set session variables
	$_SESSION['mapl_userdata' . $sn] = true;
	
	$_SESSION['mapl_fullname_user' . $sn] = $malogin_fullname;
	$_SESSION['mapl_name_user' . $sn] = $_POST['mapl_username'];
	$_SESSION['mapl_passwd_user' . $sn] = md5($plugin_cf['membersarea']['md5_before'] . $_POST['mapl_password'] . $plugin_cf['membersarea']['md5_after']);
	$_SESSION['mapl_group_user' . $sn] = $malogin_group;
	$_SESSION['mapl_email_user' . $sn] = $malogin_email;
	if(isset($malogin_invoice_addr)) $_SESSION['mapl_invoice_addr' . $sn] = $malogin_invoice_addr;
	if(isset($malogin_delivery_addr)) $_SESSION['mapl_delivery_addr' . $sn] = $malogin_delivery_addr;
	
//	echo '<br><br><br><br><br>xxxxxxxx' . $_SESSION['mapl_invoice_addr' . $sn];
}




// define if username or fullname is shown, if a member is logged in

if(isset($_SESSION['mapl_userdata' . $sn]) || isset($_SESSION['mapl_userdata']))
{
	if($plugin_cf['membersarea']['show_fullname'] == 'true')
	{
		$mapl_shown_name = str_replace($sn,'',$_SESSION['mapl_fullname_user' . $sn]);
	}
	else
	{
		$mapl_shown_name = str_replace($sn,'',$_SESSION['mapl_name_user' . $sn]);
	}
}


/*
########################
   LOGFILE MANAGEMENT
########################
*/

//define logfile

if(file_exists('./' . $plugin_cf['membersarea']['data_path_logfile']))
{
	$mapl_logfile = './' . $plugin_cf['membersarea']['data_path_logfile'];
}
else
{
	$mapl_logfile = $pth['folder']['base'] . $plugin_cf['membersarea']['data_path_logfile'];
}

// get logfile content

if(file_exists('./' . $plugin_cf['membersarea']['data_path_logfile']))
{
	$mapl_logfile_content = file_get_contents('./' . $plugin_cf['membersarea']['data_path_logfile']);
}
else
{
	$mapl_logfile_content = file_get_contents($pth['folder']['base'] . $plugin_cf['membersarea']['data_path_logfile']);
}

// for failed login
if(isset($_POST['mapl_login_control']) && $_POST['mapl_login_control'] == 'true' && !isset($_SESSION['mapl_userdata' . $sn]) && !isset($_SESSION['mapl_userdata']))
{
	$o.= '<p class="mapl_message_failed">' . $plugin_tx['membersarea']['message_login_error'] . '</p>';
	
	// write logfile
	$mapl_writelog_handle = fopen($mapl_logfile,'w');
	fwrite($mapl_writelog_handle, date('Y-m-d H:i:s') . ' - ##### Login failed ##### (' . $sn . ")\n" . $mapl_logfile_content);
	fclose($mapl_writelog_handle);
}

// write logfile for login
if
(
	isset($_POST['mapl_login_control']) && $_POST['mapl_login_control'] == 'true' && 
	$_POST['mapl_username'] != '' && 
	$_POST['mapl_password'] != ''&& 
	strstr(file_get_contents($mapl_data_file), '-- --' . $_POST['mapl_username'] . '-- --' . md5($plugin_cf['membersarea']['md5_before'] . $_POST['mapl_password'] . $plugin_cf['membersarea']['md5_after']) . '-- --') 
)
{
	$mapl_writelog_handle = fopen($mapl_logfile,'w');
	fwrite($mapl_writelog_handle, date('Y-m-d H:i:s') . ' - "' . $_POST['mapl_username'] . '" has logged in (' . $sn . ")\n" . $mapl_logfile_content);
	fclose($mapl_writelog_handle);
}

// write logfile for logout
if(isset($_POST['mapl_logout']))
{
	$mapl_writelog_handle = fopen($mapl_logfile,'w');
	fwrite($mapl_writelog_handle, date('Y-m-d H:i:s') . ' - "' . $_SESSION['mapl_name_user' . $sn] . '" has logged out (' . $sn . ")\n" . $mapl_logfile_content);
	fclose($mapl_writelog_handle);
}

// write logfile for change userdata
if
(
	isset($mapl_change_userdata) && 
	(isset($_SESSION['mapl_userdata' . $sn]) || isset($_SESSION['mapl_userdata'])) && 
	isset($_POST['macud_control'])
)
{
	$macud_writelog_handle = fopen($mapl_logfile,'w');
	fwrite($macud_writelog_handle, date('Y-m-d H:i:s') . ' - "' . $_SESSION['mapl_name_user' . $sn] . '" has changed userdata (' . $sn . ")\n" . $mapl_logfile_content);
	fclose($macud_writelog_handle);
}


/*
########################
   HIDE MEMBERPAGES
########################
*/

if(!$edit)
{
	for($i = 0; $i < $cl; $i++) 
	{
		$plugindata = $c[$i];
		if (preg_match('/{{{plugin:membersarea_protect\((.*?)}}}/is',$plugindata))
		{
			if
			(
				!isset($_SESSION['mapl_userdata' . $sn]) && !isset($_SESSION['mapl_userdata']) || 
				isset($_POST['mapl_logout']) || 
				!preg_match('/{{{plugin:membersarea_protect\((.*?)!' . $_SESSION['mapl_group_user' . $sn] . '!(.*?)}}}/is',$plugindata) && 
				!preg_match('/{{{plugin:membersarea_protect\(\)(.*?)}}}/is',$plugindata)
			)
			{
				$c[$i] = '#CMSimple hide#';
			}
		}
	}
}


/*
########################
   MEMBERSAREA LOGOUT
########################
*/

if(isset($_POST['mapl_logout']))
{
	$o.='<p class="mapl_message_success">'.$plugin_tx['membersarea']['message_logged_out'].'</p>';
	
	unset($_SESSION['mapl_userdata' . $sn]);
	
	unset($_SESSION['mapl_fullname_user' . $sn]);
	unset($_SESSION['mapl_name_user' . $sn]);
	unset($_SESSION['mapl_passwd_user' . $sn]);
	unset($_SESSION['mapl_group_user' . $sn]);
	unset($_SESSION['mapl_email_user' . $sn]);
	unset($_SESSION['mapl_invoice_addr' . $sn]);
	unset($_SESSION['mapl_delivery_addr' . $sn]);
}


/*
########################
  MEMBERSAREA REGISTER
########################
*/

if(isset($mapl_register))
{
	if($plugin_cf['membersarea']['allow_newmember_register'] == 'true')
	{
		$o.= "\n" . '<h2>' . $plugin_tx['membersarea']['headline_register_page'] . '</h2>' . "\n";
		$o.= '<p>' . $plugin_tx['membersarea']['register_page_text1'] . '</p>' . "\n";
		$o.= '<p>' . $plugin_tx['membersarea']['register_page_text2'] . '</p>' . "\n";
		$o.= "\n" . '<div class="mareg_register_form">' . "\n";
		$o.='<form method="POST" action="#" autocomplete="off">' . "\n";
		$o.='<div class="mareg_input">' . "\n";
		
		$o.= $plugin_tx['membersarea']['user_name_full'] . ':' . '<br><input type="text" id="mareg_newmember_full_name" name="mareg_newmember_full_name" value="' . (isset($_POST['mareg_newmember_full_name'])?$_POST['mareg_newmember_full_name']:'') . '">' . "\n";
		$o.= '<div style="clear: both;"></div>' . "\n";
		
		$o.= $plugin_tx['membersarea']['user_name'] . ':<br><input type="text" id="mareg_newmember_name" name="mareg_newmember_name" value="' . (isset($_POST['mareg_newmember_name'])?$_POST['mareg_newmember_name']:'') . '">' . "\n";
		$o.= '<div style="clear: both;"></div>' . "\n";
		
		$o.= $plugin_tx['membersarea']['user_password'] . ':<br><input type="password" id="mareg_newmember_passwd" name="mareg_newmember_passwd" value="' . (isset($_POST['mareg_newmember_passwd'])?$_POST['mareg_newmember_passwd']:'') . '">' . "\n";
		$o.= '<div style="clear: both;"></div>' . "\n";
		
		$o.= $plugin_tx['membersarea']['user_mail'] . ':<br><input type="text" id="mareg_newmember_mail" name="mareg_newmember_mail" value="' . (isset($_POST['mareg_newmember_mail'])?$_POST['mareg_newmember_mail']:'') . '">' . "\n" . '</div>' . "\n";
		$o.= '<div style="clear: both;"></div>' . "\n";
		
		$o.= '<input type="checkbox" id="mareg_send_password" name="mareg_send_password" value="true" style="float: left; margin: 7px 9px 0 0;"><label for="mareg_send_password" style="line-height: 28px;">' . $plugin_tx['membersarea']['register_mail_send_password'] . '</label>';

		$o.= '<input type="hidden" id="mareg_newmember_control" name="mareg_newmember_control" value="control">' . "\n";
		$o.= '<div style="clear: both;"></div>' . "\n";
		$o.= '<input type="submit" value="' . $plugin_tx['membersarea']['button_register'] . '" class="mareg_submit">' . "\n" . '</form>' . "\n";
		$o.= '<div style="clear: both;"></div>' . "\n";
		$o.= '</div>' . "\n";
		
		if(isset($_POST['mareg_newmember_control']))
		{
			$mareg_newmember_full_name = mapl_clean_user_input($_POST['mareg_newmember_full_name']);
			$mareg_newmember_name = mapl_clean_user_input($_POST['mareg_newmember_name']);
			$mareg_newmember_mail = mapl_clean_user_input($_POST['mareg_newmember_mail']);
			$mareg_newmember_pw = md5($plugin_cf['membersarea']['md5_before'] . $_POST['mareg_newmember_passwd'] . $plugin_cf['membersarea']['md5_after']);
			
			$mareg_newmember_dataset = $mareg_newmember_full_name . '-- --' . $mareg_newmember_name . '-- --' . $mareg_newmember_pw . '-- --|||' . $plugin_cf['membersarea']['register_newmembers_group'] . '|||-- --' . $mareg_newmember_mail . '-- --...-- --...';
		}
		
		
		// some messages
		
		if(isset($_POST['mareg_newmember_name']) && substr_count(file_get_contents($mapl_data_file), '-- --' . $_POST['mareg_newmember_name'] . '-- --') > 0 && $_POST['mareg_newmember_control'] != '')
		{
			$o.= '<p class="mapl_message_failed">' . $plugin_tx['membersarea']['message_form_user_exists'] . '</p>';
		}
		elseif(isset($_POST['mareg_newmember_mail']) && substr_count(file_get_contents($mapl_data_file), '|||-- --' . $_POST['mareg_newmember_mail']) > 0 && $_POST['mareg_newmember_control'] != '')
		{
			$o.= '<p class="mapl_message_failed">' . $plugin_tx['membersarea']['message_form_mail_exists'] . '</p>';
		}
		elseif
		(
			(isset($_POST['mareg_newmember_full_name']) && preg_match('!<|>|"|\'|\/|\*|\||\#|;!i', $_POST['mareg_newmember_full_name'])) || 
			(isset($_POST['mareg_newmember_name']) && preg_match('!<|>|"|\'|\/|\*|\||\#|;!i', $_POST['mareg_newmember_name'])) || 
			(isset($_POST['mareg_newmember_group']) && preg_match('!<|>|"|\'|\/|\*|\||\#|;!i', $_POST['mareg_newmember_group'])) ||  
			(isset($_POST['mareg_newmember_mail']) && preg_match('!<|>|"|\'|\/|\*|\||\#|;!i', $_POST['mareg_newmember_mail'])) || 
			(isset($_POST['mareg_newmember_passwd']) && preg_match('!<|>|"|\'|\/|\*|\||\#|;!i', $_POST['mareg_newmember_passwd'])) 
		)
		{
			$o.= '<p class="mapl_message_failed">' . $plugin_tx['membersarea']['message_wrong_characters'] . '</p>';
		}
		elseif
		(
			isset($_POST['mareg_newmember_mail']) && !preg_match('/(.*?)+@(.*?)+\.[\w]/', $_POST['mareg_newmember_mail'])
		)
		{
			$o.= '<p class="mapl_message_failed">' . $plugin_tx['membersarea']['message_wrong_email'] . '</p>';
		}
		else
		{
			if
			(
				isset($_POST['mareg_newmember_full_name']) && $_POST['mareg_newmember_full_name'] != '' && 
				isset($_POST['mareg_newmember_name']) && $_POST['mareg_newmember_name'] != '' && 
				isset($_POST['mareg_newmember_passwd']) && $_POST['mareg_newmember_passwd'] != '' && 
				isset($_POST['mareg_newmember_mail']) && $_POST['mareg_newmember_mail'] != ''
			)
			{
				$mareg_newmember_handle = fopen($mapl_data_file,'a');
				fwrite($mareg_newmember_handle, "\n\n" . stripslashes(trim($mareg_newmember_dataset)));
				fclose($mareg_newmember_handle);
				
				$o = '<p class="mapl_message_success">' . str_replace('<br><br><br><br>','<br><br>', str_replace("\r",'<br>',str_replace("\n",'<br>',$plugin_tx['membersarea']['message_registered']))) . '</p>' . "\n";
				$o.= '<p>' . str_replace('<br><br><br><br>','<br><br>', str_replace("\r",'<br>',str_replace("\n",'<br>',$plugin_tx['membersarea']['message_registered_limited']))) . '</p>' . "\n";
				
				// mail for user
				$mareg_usermail_header = 'From: ' . $plugin_cf['membersarea']['register_email_admin'] . "\r\n";
				$mareg_usermail_header.= 'Reply-To: ' . $plugin_cf['membersarea']['register_email_admin'] . "\r\n";
				$mareg_usermail_header.= 'Content-Type: text/plain; charset="UTF-8"' . "\r\n";
				
				$mareg_usermail_subject = 'MembersArea ' . sv('SERVER_NAME') . $sn;
				
				$mareg_usermail_content = $plugin_tx['membersarea']['register_mail_user_text1'] . ' ' . sv('SERVER_NAME') . $sn . "\r\n\r\n";
				$mareg_usermail_content.= $plugin_tx['membersarea']['register_mail_user_text2'] . "\r\n\r\n";
				$mareg_usermail_content.= $plugin_tx['membersarea']['user_name'] . ': ' . $_POST['mareg_newmember_name'] . "\r\n";
				if(isset($_POST['mareg_send_password']) && $_POST['mareg_send_password'] == 'true') $mareg_usermail_content.= $plugin_tx['membersarea']['user_password'] . ': ' . $_POST['mareg_newmember_passwd'] . "\r\n";
				$mareg_usermail_content.= $plugin_tx['membersarea']['user_mail'] . ': ' . $_POST['mareg_newmember_mail'] . "\r\n";
				$mareg_usermail_content = htmlentities($mareg_usermail_content,ENT_QUOTES,'UTF-8');
				$mareg_usermail_content = html_entity_decode($mareg_usermail_content,ENT_QUOTES,'UTF-8');
				
				mail($_POST['mareg_newmember_mail'], $mareg_usermail_subject, $mareg_usermail_content,$mareg_usermail_header);
				
				
				// mail for admin
				$mareg_adminmail_header = 'From: ' . $plugin_cf['membersarea']['register_email_admin'] . "\r\n";
				$mareg_adminmail_header.= 'Reply-To: ' . $plugin_cf['membersarea']['register_email_admin'] . "\r\n";
				$mareg_adminmail_header.= 'Content-Type: text/plain; charset="UTF-8"' . "\r\n";
				
				$mareg_adminmail_subject = 'MembersArea ' . sv('SERVER_NAME') . $sn;
				
				$mareg_adminmail_content = $plugin_tx['membersarea']['register_mail_admin_text1'] . ' ' . sv('SERVER_NAME') . $sn . "\r\n\r\n";
				$mareg_adminmail_content.= $plugin_tx['membersarea']['register_mail_admin_text2'] . "\r\n\r\n";
				$mareg_adminmail_content.= $plugin_tx['membersarea']['user_name'] . ': ' . $_POST['mareg_newmember_name'] . "\r\n";
				$mareg_adminmail_content.= $plugin_tx['membersarea']['user_mail'] . ': ' . $_POST['mareg_newmember_mail'] . "\r\n";
				$mareg_adminmail_content = htmlentities($mareg_adminmail_content,ENT_QUOTES,'UTF-8');
				$mareg_adminmail_content = html_entity_decode($mareg_adminmail_content,ENT_QUOTES,'UTF-8');
				
				mail($plugin_cf['membersarea']['register_email_admin'], $mareg_adminmail_subject, $mareg_adminmail_content,$mareg_adminmail_header);
			}
			else
			{
				if(isset($_POST['mareg_newmember_control']) && $_POST['mareg_newmember_control'] != '')
				{
					$o.='<p class="mapl_message_failed">' . $plugin_tx['membersarea']['message_form_input'] . '</p>';
				}
			}
		}
	}
	else
	{
		$o = '<h2>Register function disabled</h2>';
	}
}


/*
########################
  MEMBERSAREA USERDATA
########################
*/

if(isset($mapl_change_userdata) && (isset($_SESSION['mapl_userdata' . $sn]) || isset($_SESSION['mapl_userdata'])))
{
	if($plugin_cf['membersarea']['allow_edit_userdata'] == 'true' && $_SESSION['mapl_name_user' . $sn] != $plugin_cf['membersarea']['general_user'])
	{
		// form "change userdata"
		$o.= "\n" . '<h2>' . $plugin_tx['membersarea']['headline_change_userdata'] . '</h2>' . "\n";
		$o.= '<hr>' . "\n";
		$o.= '<p><b>' . $plugin_tx['membersarea']['user_name'] . ': </b>' . $_SESSION['mapl_name_user' . $sn] . '</p>' . "\n";
		$o.= '<p><b>' . $plugin_tx['membersarea']['user_group'] . ': </b>' . $_SESSION['mapl_group_user' . $sn] . '</p>' . "\n";
		$o.= '<hr>' . "\n";
		$o.= $plugin_tx['membersarea']['register_page_text2'] . "\n";
		$o.= "\n" . '<div class="macud_userdata_form">' . "\n";
		$o.='<form method="POST" action="#" autocomplete="off">' . "\n";
		$o.='<div class="macud_input">' . "\n";
		
		$o.= $plugin_tx['membersarea']['user_name_full'] . ':<br><input type="text" id="macud_fullname" name="macud_fullname" value="' . $_SESSION['mapl_fullname_user' . $sn] . '">' . "\n";
		
		$o.= '<br style="clear: both;">' . $plugin_tx['membersarea']['user_mail'] . ':<br><input type="text" id="macud_mail" name="macud_mail" value="' . $_SESSION['mapl_email_user' . $sn] . '">' . "\n";
		
		if($_SESSION['mapl_group_user' . $sn] == 'customer' || $_SESSION['mapl_group_user' . $sn] == 'premium_customer')
		{
			$o.= '<br style="clear: both;">' . $plugin_tx['membersarea']['userdata_label_invoice_addr'] . ':<br><input type="text" id="macud_invoice_addr" name="macud_invoice_addr" value="' . (isset($_SESSION['mapl_invoice_addr' . $sn])?$_SESSION['mapl_invoice_addr' . $sn]:'') . '">' . "\n";
			$o.= '<br style="clear: both;">' . $plugin_tx['membersarea']['userdata_label_delivery_addr'] . ':<br><input type="text" id="macud_delivery_addr" name="macud_delivery_addr" value="' . (isset($_SESSION['mapl_delivery_addr' . $sn])?$_SESSION['mapl_delivery_addr' . $sn]:'') . '">' . "\n";
		}
		
		$o.= '<br style="clear: both;"><br>' . $plugin_tx['membersarea']['userdata_password'] . ':<br><input type="password" id="macud_passwd" name="macud_passwd" class="macud_passwd" value="">' . "\n" . '</div>' . "\n";
		
		$o.= '<input type="checkbox" id="macud_send_password" name="macud_send_password" value="true" style="float: left; margin: 7px 9px 0 0;"><label for="macud_send_password" style="line-height: 28px;">' . $plugin_tx['membersarea']['register_mail_send_password'] . '</label>' . "\n";;
		
		$o.= '<input type="hidden" id="macud_control" name="macud_control" value="control">' . "\n";
		$o.= '<div style="clear: both;"></div>' . "\n";
		$o.= '<input type="submit" value="' . $plugin_tx['membersarea']['button_change_userdata'] . '" class="macud_submit">' . "\n" . '</form>' . "\n";
		$o.= '<div style="clear: both;"></div>' . "\n";
		$o.= '</div>' . "\n";
		
		// prepare userdata
		$macud_fullname = isset($_POST['macud_fullname'])?mapl_clean_user_input($_POST['macud_fullname']):'';
		$macud_passwd = md5($plugin_cf['membersarea']['md5_before'] . (isset($_POST['macud_passwd'])?mapl_clean_user_input($_POST['macud_passwd']):'') . $plugin_cf['membersarea']['md5_after']);
		$macud_mail = isset($_POST['macud_mail'])?mapl_clean_user_input($_POST['macud_mail']):'';
		$macud_invoice_addr = isset($_POST['macud_invoice_addr'])?mapl_clean_user_input($_POST['macud_invoice_addr']):$plugin_tx['membersarea']['userdata_input_invoice_addr'];
		$macud_delivery_addr = isset($_POST['macud_delivery_addr'])?mapl_clean_user_input($_POST['macud_delivery_addr']):$plugin_tx['membersarea']['userdata_input_delivery_addr'];
		
		//prepare datasets for replace
		
		foreach($members_array as $macud_memberData)
		{
			if(strstr($macud_memberData, '-- --' . $_SESSION['mapl_name_user' . $sn] . '-- --')) // wenn in Zeile username vorkommt
			{
				$macud_memberData = explode('-- --',$macud_memberData);
				$macud_olddata_fullname = $macud_memberData[0];
				$macud_olddata_name = $macud_memberData[1];
				$macud_olddata_passwd = $macud_memberData[2];
				$macud_olddata_group = $macud_memberData[3];
				$macud_olddata_email = $macud_memberData[4];
				if(isset($macud_memberData[5])) $macud_olddata_invoice_addr = $macud_memberData[5];
				if(isset($macud_memberData[6])) $macud_olddata_delivery_addr = $macud_memberData[6];
			}
		}
		
		if(isset($macud_olddata_invoice_addr))
		{
			$macud_dataset_old = $macud_olddata_fullname . '-- --' . $macud_olddata_name . '-- --' . $macud_olddata_passwd . '-- --' . $macud_olddata_group . '-- --' . $macud_olddata_email . '-- --' . $macud_olddata_invoice_addr . '-- --' . $macud_olddata_delivery_addr;
			$macud_dataset_new = $macud_fullname . '-- --' . $_SESSION['mapl_name_user' . $sn] . '-- --' . $macud_passwd . '-- --|||' . $_SESSION['mapl_group_user' . $sn] . '|||-- --' . $macud_mail . '-- --' . $macud_invoice_addr . '-- --' . $macud_delivery_addr . "\n";
		}
		else
		{
			$macud_dataset_old = $macud_olddata_fullname . '-- --' . $macud_olddata_name . '-- --' . $macud_olddata_passwd . '-- --' . $macud_olddata_group . '-- --' . $macud_olddata_email;
			$macud_dataset_new = $macud_fullname . '-- --' . $_SESSION['mapl_name_user' . $sn] . '-- --' . $macud_passwd . '-- --|||' . $_SESSION['mapl_group_user' . $sn] . '|||-- --' . $macud_mail . '-- --...-- --...' . "\n";
		}
		
//		echo '<br><br>ALT: ' . $macud_dataset_old . '<br>' . 'NEU: ' . $macud_dataset_new;
		
		$macud_dataset = file_get_contents($mapl_data_file);
		$macud_dataset = str_replace($macud_dataset_old,$macud_dataset_new,$macud_dataset);
		
		// write datafile
		if
		(
			isset($_POST['macud_control']) 
			&& $_POST['macud_passwd'] != ''
			&& $_POST['macud_fullname'] != ''
			&& preg_match('/(.*?)+@(.*?)+\.[\w]/', $_POST['macud_mail'])
			&& !preg_match('!<|>|"|\'|\/|\*|\||\#|;!i', $_POST['macud_passwd'])
			&& !preg_match('!<|>|"|\'|\/|\*|\||\#|;!i', $_POST['macud_fullname'])
		)
		{
			$macud_handle = fopen($mapl_data_file,'w');
			fwrite($macud_handle,trim(stripslashes($macud_dataset)));
			fclose($macud_handle);
			
			// messages and new session data
			$o = '<p class="mapl_message_success">' . $plugin_tx['membersarea']['message_userdata_changed'] . '</p>';
			$o.= $plugin_tx['membersarea']['userdata_changed_text1'];
			$o.= '<p class="mapl_message_link"><a href="./?&mapl_change_userdata">' . $plugin_tx['membersarea']['userdata_review'] . '</a></p>';
			
			$_SESSION['mapl_fullname_user' . $sn] = mapl_clean_user_input($_POST['macud_fullname']);
			$_SESSION['mapl_passwd_user' . $sn] = md5($plugin_cf['membersarea']['md5_before'] . $_POST['macud_passwd'] . $plugin_cf['membersarea']['md5_after']);
			$_SESSION['mapl_email_user' . $sn] = mapl_clean_user_input($_POST['macud_mail']);
			if(isset($_POST['macud_invoice_addr'])) $_SESSION['mapl_invoice_addr' . $sn] = mapl_clean_user_input($_POST['macud_invoice_addr']);
			if(isset($_POST['macud_delivery_addr'])) $_SESSION['mapl_delivery_addr' . $sn] = mapl_clean_user_input($_POST['macud_delivery_addr']);
			
			
			// mail for user
			$macud_usermail_header = 'From: ' . $plugin_cf['membersarea']['register_email_admin'] . "\r\n";
			$macud_usermail_header.= 'Reply-To: ' . $plugin_cf['membersarea']['register_email_admin'] . "\r\n";
			$macud_usermail_header.= 'Content-Type: text/plain; charset="UTF-8"' . "\r\n";
			
			$macud_usermail_subject = 'MembersArea ' . sv('SERVER_NAME') . $sn;
			
			$macud_usermail_content = $plugin_tx['membersarea']['userdata_mail_user_text1'] . ' ' . sv('SERVER_NAME') . $sn . "\r\n\r\n";
			$macud_usermail_content.= $plugin_tx['membersarea']['userdata_mail_user_text2'] . "\r\n\r\n";
			$macud_usermail_content.= $plugin_tx['membersarea']['user_name'] . ': ' . $_SESSION['mapl_name_user' . $sn] . "\r\n";
			$macud_usermail_content.= $plugin_tx['membersarea']['userdata_label_invoice_addr'] . ': ' . $_SESSION['mapl_invoice_addr' . $sn] . "\r\n";
			$macud_usermail_content.= $plugin_tx['membersarea']['userdata_label_delivery_addr'] . ': ' . $_SESSION['mapl_delivery_addr' . $sn] . "\r\n";
			if(isset($_POST['macud_send_password']) && $_POST['macud_send_password'] == 'true') $macud_usermail_content.= $plugin_tx['membersarea']['user_password'] . ': ' . $_POST['macud_passwd'] . "\r\n";
			$macud_usermail_content.= $plugin_tx['membersarea']['user_mail'] . ': ' . $_POST['macud_mail'] . "\r\n";
			$macud_usermail_content = htmlentities($macud_usermail_content,ENT_QUOTES,'UTF-8');
			$macud_usermail_content = html_entity_decode($macud_usermail_content,ENT_QUOTES,'UTF-8');
			
			mail($_POST['macud_mail'], $macud_usermail_subject, $macud_usermail_content,$macud_usermail_header);
			
			
			// mail for admin
			$macud_adminmail_header = 'From: ' . $plugin_cf['membersarea']['register_email_admin'] . "\r\n";
			$macud_adminmail_header.= 'Reply-To: ' . $plugin_cf['membersarea']['register_email_admin'] . "\r\n";
			$macud_adminmail_header.= 'Content-Type: text/plain; charset="UTF-8"' . "\r\n";
			
			$macud_adminmail_subject = 'MembersArea ' . sv('SERVER_NAME') . $sn;
			
			$macud_adminmail_content = $plugin_tx['membersarea']['userdata_mail_admin_text1'] . ' ' . sv('SERVER_NAME') . $sn . "\r\n\r\n";
			$macud_adminmail_content.= $plugin_tx['membersarea']['userdata_mail_admin_text2'] . "\r\n\r\n";
			$macud_adminmail_content.= $plugin_tx['membersarea']['user_name'] . ': ' . $_SESSION['mapl_name_user' . $sn] . "\r\n";
			$macud_adminmail_content.= $plugin_tx['membersarea']['userdata_label_invoice_addr'] . ': ' . $_SESSION['mapl_invoice_addr' . $sn] . "\r\n";
			$macud_adminmail_content.= $plugin_tx['membersarea']['userdata_label_delivery_addr'] . ': ' . $_SESSION['mapl_delivery_addr' . $sn] . "\r\n";
			$macud_adminmail_content.= $plugin_tx['membersarea']['user_mail'] . ': ' . $_POST['macud_mail'] . "\r\n";
			$macud_adminmail_content = htmlentities($macud_adminmail_content,ENT_QUOTES,'UTF-8');
			$macud_adminmail_content = html_entity_decode($macud_adminmail_content,ENT_QUOTES,'UTF-8');
			
			mail($plugin_cf['membersarea']['register_email_admin'], $macud_adminmail_subject, $macud_adminmail_content,$macud_adminmail_header);
		}
		else
		{
			if(isset($_POST['macud_control']))
			{
				$o.='<p class="mapl_message_failed">' . $plugin_tx['membersarea']['message_form_input'] . '</p>';
			}
			
			if(isset($_POST['macud_mail']) && !preg_match('/(.*?)+@(.*?)+\.[\w]/', $_POST['macud_mail']))
			{
				$o.='<p class="mapl_message_failed">' . $plugin_tx['membersarea']['message_wrong_email'] . '</p>';
			}
			
			if
			(
				(isset($_POST['macud_fullname']) && preg_match('!<|>|"|\'|\/|\*|\||\#|;!i', $_POST['macud_fullname'])) || 
				(isset($_POST['macud_mail']) && preg_match('!<|>|"|\'|\/|\*|\||\#|;!i', $_POST['macud_mail'])) ||
				(isset($_POST['macud_passwd']) && preg_match('!<|>|"|\'|\/|\*|\||\#|;!i', $_POST['macud_passwd'])) 
			)
			{
				$o.= '<p class="mapl_message_failed">' . $plugin_tx['membersarea']['message_wrong_characters'] . '</p>';
			}
		}
	}
}

if(isset($mapl_change_userdata) && !isset($_SESSION['mapl_userdata' . $sn]) && !isset($_SESSION['mapl_userdata']))
{
	$o = '<h2>"Change user data" disabled</h2>';
}


/*
########################
      FUNCTIONS
########################
*/

function membersarea_login($mapl_login_page = "", $mapl_logout_page = "")
{
	global $sn,$su,$plugin_cf,$plugin_tx,$mapl_shown_name;
	
	if(!defined('CMSIMPLE_VERSION'))
	{
		return '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="http://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
	}

// login form
	
	if(!isset($_SESSION['mapl_userdata' . $sn]) && !isset($_SESSION['mapl_userdata']) || isset($_POST['mapl_logout']))
	{
		$mapl_output = "\n\n" . '<div class="mapl_loginform">' . "\n";
		$mapl_output.= '<form action="#" method="post">' . "\n";
		$mapl_output.= $plugin_tx['membersarea']['user_name'] . '<br>' . "\n";
		$mapl_output.= '<input type="hidden" name="mapl_login_control" value="true">' . "\n";
		$mapl_output.= '<input type="text" name="mapl_username" class="mapl_loginform_input"><br>' . "\n";
		$mapl_output.= $plugin_tx['membersarea']['user_password'] . '<br>' . "\n";
		$mapl_output.= '<input type="password" name="mapl_password" class="mapl_loginform_input"><br>' . "\n";
		
		$mapl_output.= '<input type="submit" name="submit" class="mapl_loginform_submit" value="'.$plugin_tx['membersarea']['status_login'] . '">' . "\n";
		$mapl_output.= '</form>' . "\n";
		$mapl_output.= '</div>' . "\n\n";
		
		// register link
		if($plugin_cf['membersarea']['allow_newmember_register'] == 'true' && $plugin_cf['membersarea']['register_show_registerlink'] == 'true')
		{
			$mapl_output.='<p><a href="./?&amp;mapl_register">' . $plugin_tx['membersarea']['register_link'] . '</a></p>';
		}
	}
	
// go to login page, if defined
	
	if(isset($mapl_login_page) && $mapl_login_page != "")
	{
		if(isset($_POST['mapl_username']) && (isset($_SESSION['mapl_userdata' . $sn]) || isset($_SESSION['mapl_userdata'])))
		{
			header('Location: ' . $sn . '?' . $mapl_login_page);
		}
		else
		{
			$o = '<p class="mapl_message_failed">' . $plugin_tx['membersarea']['message_login_error'] . '</p>';
		}
	}
	
// logged_in form
	
	if(!isset($_POST['mapl_logout']) && (isset($_SESSION['mapl_userdata' . $sn]) || isset($_SESSION['mapl_userdata'])))
	{
		$mapl_output = "\n\n" . '<div class="mapl_logged_in_form">' . "\n";
		$mapl_output.= '<p><b>' . $plugin_tx['membersarea']['message_hello'] . ' ' . $mapl_shown_name . ',</b></p>' . "\n" . '<p>' . $plugin_tx['membersarea']['status_logged_in'] . '</p>' . "\n";
		$mapl_output.= '<form action="' . $sn . '?' . $su . '" method="post">' . "\n";
		$mapl_output.= '<input type="hidden" id="mapl_logout" name="mapl_logout" value="mapl_logout">' . "\n";
		$mapl_output.= '<input type="hidden" id="mapl_logout" name="mapl_logout_page" value="' . $mapl_logout_page . '">' . "\n";
		$mapl_output.= '<input type="submit" class="mapl_loggedinform_submit" value="' . $plugin_tx['membersarea']['status_logout'] . '">' . "\n";
		$mapl_output.= '</form>' . "\n";
		$mapl_output.= '</div>' . "\n\n";
	}
	
	if($plugin_cf['membersarea']['allow_edit_userdata'] == 'true' && (isset($_SESSION['mapl_userdata' . $sn]) || isset($_SESSION['mapl_userdata'])) && $_SESSION['mapl_name_user' . $sn] != $plugin_cf['membersarea']['general_user'])
	{
		$mapl_output.='<p><a href="./?&mapl_change_userdata">' . $plugin_tx['membersarea']['userdata_link'] . '</a></p>';
	}

	if(isset($_POST['mapl_logout_page']) && $_POST['mapl_logout_page'] != "")
	{
		if(isset($_POST['mapl_logout']))
		{
			header('Location: ' . $sn . '?' . $mapl_logout_page);
		}
	}

	return $mapl_output;
}


function membersarea_loggedin_hint($mapl_logout_page_hint = "")
{
	global $sn,$su,$plugin_tx,$mapl_shown_name;
	
	if((isset($_SESSION['mapl_userdata' . $sn]) || isset($_SESSION['mapl_userdata'])) && !isset($_POST['mapl_logout']))
	{
		$mapl_output = "\n\n" . '<div class="mapl_logged_in_hint">' . "\n";
		$mapl_output.= '<form action="' . $sn . '?' . $su . '" method="post">' . "\n";
		$mapl_output.= '<b>' . $plugin_tx['membersarea']['message_hello'] . ' ' . $mapl_shown_name . ', </b>' . $plugin_tx['membersarea']['status_logged_in'] . '&nbsp;' . "\n";
		$mapl_output.= '<input type="hidden" name="mapl_logout" value="mapl_logout">' . "\n";
		$mapl_output.= '<input type="hidden" name="mapl_logout_page_hint" value="' . $mapl_logout_page_hint . '">' . "\n";
		$mapl_output.= '<input type="submit" class="mapl_loginhint_submit" value="' . $plugin_tx['membersarea']['status_logout'] . '">' . "\n";
		$mapl_output.= '</form>' . "\n";
		$mapl_output.= '</div>' . "\n\n";
		return $mapl_output;
	}
	else
	{
		if(isset($_POST['mapl_logout_page_hint']) && $_POST['mapl_logout_page_hint'] != "")
		{
			header('Location: ' . $sn . '?' . $_POST['mapl_logout_page_hint']);
		}
		else return '';
	}
}


function membersarea_protect()
{
	if(!defined('CMSIMPLE_VERSION'))
	{
		return '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="http://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
	}
	else return '';
}

function mapl_clean_user_input($user_input)
{
	global $sn;

	$mapl_cleaned_user_input = str_replace('- -','-',$user_input);
	$mapl_cleaned_user_input = str_replace('|','',$mapl_cleaned_user_input);
	$mapl_cleaned_user_input = preg_replace('/\-+/','-',$mapl_cleaned_user_input);
	$mapl_cleaned_user_input = strip_tags($mapl_cleaned_user_input);
	$mapl_cleaned_user_input = htmlspecialchars($mapl_cleaned_user_input, ENT_QUOTES, "UTF-8");
	
	if($mapl_cleaned_user_input == '')
	{
		$mapl_cleaned_user_input = 'empty';
	}
	return $mapl_cleaned_user_input;
}

?>