<?php // utf-8 marker: äöü

/*
==========================================
Plugin BackupMail for CMSimple
Developed by: ge-webdesign.de
Version: BackupMail 2.0
Released: 2023-01
==========================================
License: Commercial License
see https://www.ge-webdesign.de/cmsimpleplugins/?terms_of_use
==========================================
*/

if (!function_exists('sv') || preg_match('#/plugins/backupmail/index.php#i', $_SERVER['SCRIPT_NAME']))
{
	die('no direct access');
}

define('BACKUPMAIL_VERSION', '2.0');

function createBackupZip()
{
	global $plugin_cf, $backupmail_folders_array, $backupmail_files_array;
	
	if(!defined('CMSIMPLE_VERSION'))
	{
		return '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="https://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
	}
	
	if($plugin_cf['backupmail']['create_zip_files'] == 'true')
	{
		// create zip file

		$zip = new ZipArchive;
		$resource = $zip->open($plugin_cf['backupmail']['data_path_zipfiles'] . date("Ymd_His") . '_' . uniqid() . '_backup.zip', ZipArchive::CREATE );

		if ($resource === TRUE)
		{
			// add folders
			
			if($backupmail_folders_array != '')
			{
				foreach($backupmail_folders_array as $backupmail_zipfolder)
				{
					if(is_dir($backupmail_zipfolder))
					{
						$verzeichnis = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($backupmail_zipfolder));
						foreach($verzeichnis as $datei)
						{
							if(basename($datei) != '.' && basename($datei) != '..')
							{
								$zip->addFile($datei, 'backupmail_folders/' . str_replace('./','',$datei));
							}
						}
					}
				}
			}
			
			
			// add files
			
			if($backupmail_files_array != '')
			{
				foreach($backupmail_files_array as $backupmail_zipfile)
				{
					if(file_exists($backupmail_zipfile))
					{
						$zip->addFile($backupmail_zipfile, str_replace('./', '', $backupmail_zipfile));
					}
				}
			}
		}
		$zip->close();
	}
}

// mail function 

function mailAttachements($to,$subject,$message,$anhang)
{
	global $cf, $plugin_cf, $plugin_tx;
	
	if(!defined('CMSIMPLE_VERSION'))
	{
		return '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="https://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
	}

	$absender      = "BackupMail CMSimple";
	$absender_mail = $cf['mailform']['email'];
	$reply         = $cf['mailform']['email'];

	$mime_boundary = "-----=" . md5(uniqid(mt_rand(), 1));

	$header  ="From:".$absender."<".$absender_mail.">\n";
	$header .= "Reply-To: ".$reply."\n";

	$header.= "MIME-Version: 1.0\r\n";
	$header.= "Content-Type: multipart/mixed;\r\n";
	$header.= " boundary=\"".$mime_boundary."\"\r\n";

	$content = "This is a multi-part message in MIME format.\r\n\r\n";
	$content.= "--".$mime_boundary."\r\n";
	$content.= "Content-Type: text/plain; charset=" . $plugin_tx['backupmail']['mail_encoding'] . "\r\n";
	$content.= "Content-Transfer-Encoding: 8bit\r\n\r\n";
	$content.= $message."\r\n";

	if(is_array($anhang) AND is_array(current($anhang)))
	{
		foreach($anhang AS $dat)
		{
		$data = chunk_split(base64_encode($dat['data']));
		$content.= "--".$mime_boundary."\r\n";
		$content.= "Content-Disposition: attachment;\r\n";
		$content.= "\tfilename=\"".$dat['name']."\";\r\n";
		$content.= "Content-Length: ".$dat['size'].";\r\n";
		$content.= "Content-Type: ".$dat['type']."; name=\"".$dat['name']."\"\r\n";
		$content.= "Content-Transfer-Encoding: base64\r\n\r\n";
		$content.= $data."\r\n";
		}
	$content .= "--".$mime_boundary."--"; 
	}
	else 
	{
		$data = chunk_split(base64_encode($anhang['data']));
		$content.= "--".$mime_boundary."\r\n";
		$content.= "Content-Disposition: attachment;\r\n";
		$content.= "\tfilename=\"".$anhang['name']."\";\r\n";
		$content.= "Content-Length: ".$anhang['size'].";\r\n";
		$content.= "Content-Type: ".$anhang['type']."; name=\"".$anhang['name']."\"\r\n";
		$content.= "Content-Transfer-Encoding: base64\r\n\r\n";
		$content.= $data."\r\n";
	} 

	if
	(
		mail
		(
			$to, 
			stripslashes(html_entity_decode($subject, ENT_NOQUOTES, $plugin_tx['backupmail']['mail_encoding'])), 
			stripslashes(html_entity_decode($content, ENT_NOQUOTES, $plugin_tx['backupmail']['mail_encoding'])), 
			$header
		)
	) 
	{
		return true;
	}
	else 
	{
		return false;
	}
} 

function createBackupZipArray()
{
	global $plugin_cf, $backupmail_files_array, $backupmail_folders_array;
	
	if(!defined('CMSIMPLE_VERSION'))
	{
		return '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="https://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
	}
	
	// create array of backup FILES 

	$backupmail_files = file_get_contents($plugin_cf['backupmail']['data_file_files']);
	$backupmail_files = str_replace("\r\n", "\n", $backupmail_files);
	$backupmail_files = str_replace("\r", "\n", $backupmail_files);
	$backupmail_files = str_replace("\n\n", "\n", $backupmail_files);

	$backupmail_files_array = explode("\n", trim($backupmail_files));
	sort($backupmail_files_array);


	// create array of backup FOLDERS 

	$backupmail_folders = file_get_contents($plugin_cf['backupmail']['data_file_folders']);
	$backupmail_folders = str_replace("\r\n", "\n", $backupmail_folders);
	$backupmail_folders = str_replace("\r", "\n", $backupmail_folders);
	$backupmail_folders = str_replace("\n\n", "\n", $backupmail_folders);

	$backupmail_folders_array = explode("\n", trim($backupmail_folders));
	sort($backupmail_folders_array);
}

function createZipfilesArray()
{
	global $plugin_cf, $backupmail_zipfiles;
	
	if(!defined('CMSIMPLE_VERSION'))
	{
		return '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="https://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
	}
	
	$backupmail_zipfiles = array();
	
	if($backupmail_zipfiles_handle = opendir($plugin_cf['backupmail']['data_path_zipfiles']))
	{
		while($backupmail_zipfile = readdir($backupmail_zipfiles_handle))
		{
			if
			(
				$backupmail_zipfile != '.' && 
				$backupmail_zipfile != '..' && 
				$backupmail_zipfile != '.htaccess' && 
				$backupmail_zipfile != 'index.html' && 
				$backupmail_zipfile != 'index.htm' && 
				$backupmail_zipfile != 'index.php'
			)
			{
				$backupmail_zipfiles[] = $backupmail_zipfile;
				sort($backupmail_zipfiles);
			}
		}
	}
}

function deleteBackupZip()
{
	global $adm, $plugin_cf, $backupmail_zipfiles;
	
	if(!defined('CMSIMPLE_VERSION'))
	{
		return '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="https://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
	}
	
	// delete oldest file, if more files than configured

	if(count($backupmail_zipfiles) > $plugin_cf['backupmail']['number_of_zipfiles'])
	{
		unlink($plugin_cf['backupmail']['data_path_zipfiles'] . $backupmail_zipfiles[0]);
	}
}

function bmPrepareMaildata()
{
	global $plugin_cf, $backupmail_zipfiles, $backupmail_files_array, $anhang;
	
	if(!defined('CMSIMPLE_VERSION'))
	{
		return '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="https://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
	}

	if($plugin_cf['backupmail']['create_and_send_mail'] == 'true')
	{
		if($plugin_cf['backupmail']['create_zip_files'] == 'true' && isset($backupmail_zipfiles))
		{
			$pfad = $plugin_cf['backupmail']['data_path_zipfiles'] . $backupmail_zipfiles[count($backupmail_zipfiles) - 1];

			$anhang = array();

			$anhang["size"] = filesize($pfad);
			$anhang["data"] = implode("",file($pfad));
			$anhang["name"] = basename($pfad);

			if(function_exists("mime_content_type"))
			{
				$anhang["type"] = mime_content_type($pfad);
			}
			else
			{
				$anhang["type"] = "application/octet-stream"; 
			}
		}
		else
		{
			$anhang = array();
			foreach($backupmail_files_array AS $name)
			{
				$size = filesize($name);
				$data = implode("",file($name));
				$name = basename($name);

				if(function_exists("mime_content_type"))
				{
					$type = mime_content_type($name);
				}
				else
				{
					$type = "text/plain";
				}
				$anhang[] = array("name"=>$name, "size"=>$size, "type"=>$type, "data"=>$data);
			}
		}
	}
}

function bmSendBackupMail()
{
	global $sn, $plugin_cf, $plugin_tx, $backupmail_zipfiles, $backupmail_files_array, $anhang;
	
	if(!defined('CMSIMPLE_VERSION'))
	{
		return '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="https://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
	}

	if(isset($_POST['bm_send_backupmail']))
	{
		mailAttachements(
		$plugin_cf['backupmail']['mail_adresses'],
		htmlentities($plugin_tx['backupmail']['mail_title'], ENT_NOQUOTES, 'UTF-8') . ' - ' . $_SERVER['SERVER_NAME'] . $sn,
		htmlentities($plugin_tx['backupmail']['mail_content'], ENT_NOQUOTES, 'UTF-8') . "\r\n" . "\r\n" . 
		htmlentities($plugin_tx['backupmail']['mailform_author'], ENT_NOQUOTES, 'UTF-8') . ' '. 
		htmlentities($_POST['bm_author'], ENT_NOQUOTES, 'UTF-8') . "\r\n" . "\r\n" . 
		htmlentities($_POST['bm_textarea'], ENT_NOQUOTES, 'UTF-8'),
		$anhang);
	}
}


// BackupMail reminder link

if($adm && $plugin_cf['backupmail']['show_remember_link'] == 'true' && !isset($backupmail_form) && !$print)
{
	if(!defined('CMSIMPLE_VERSION'))return;
	$o.= '<p>
<a href="./?&backupmail&admin=plugin_main&action=plugin_text&backupmail_form&normal">BackupMail &raquo;</a>
</p>
';
}


if(isset($xh_hasher)) $cmsimple_pwHasher = $xh_hasher;


// mailform 

if
(
	($logout || stristr($_SERVER['QUERY_STRING'], '&logged-out')) && 
	($plugin_cf['backupmail']['create_and_send_mail'] == 'true' || $plugin_cf['backupmail']['create_zip_files'] == 'true') && 
	$plugin_cf['backupmail']['show_form_after_logout'] == 'true'
)
{
	if(!defined('CMSIMPLE_VERSION'))
	{
		$o.= '<p><b>BackupMail:</b> This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="https://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
		return;
	}
	
	if(!isset($_POST['backupmail']))
	{
		$cf['meta']['robots'] = "noindex";
		$onload .= "self.focus();document.login.passwd.focus();";
		$f = $tx['menu']['login'];
		$o .= '<h4 style="text-align: center;">' . $plugin_tx['backupmail']['mailform_headline'] . '</h4>
<div id="backupmail_main">
<form id="bm_login" name="bm_login" action="' . $sn . '?&amp;logout" method="post">' . "\n";

		if($plugin_cf['backupmail']['create_zip_files'] == 'true')
		{
			$o .= '<p><input type="checkbox" name="bm_create_backup" value="bm_create_backup" checked="checked" /> &nbsp;' . $plugin_tx['backupmail']['mailform_checkbox_backup'] . '</p>';
		}

		if($plugin_cf['backupmail']['create_and_send_mail'] == 'true')
		{
			$o .= '<p><input type="checkbox" name="bm_send_backupmail" value="bm_send_backupmail" checked="checked" /> &nbsp;' . $plugin_tx['backupmail']['mailform_checkbox_mail'] . '</p>';
		}
		
		if($plugin_cf['backupmail']['show_inputfield_author'] == 'true')
		{
			$o .= '<p>' . $plugin_tx['backupmail']['mailform_author'] . '</p>' . "\n"
 . tag('input class="bm_input" type="text" name="bm_author" id="bm_author" value=""') . "\n";
		}
 
		if($plugin_cf['backupmail']['show_textarea_notice'] == 'true')
		{
			$o .= '<p>' . $plugin_tx['backupmail']['mailform_short_notice'] . '</p>' . "\n"
 . '<textarea class="bm_textarea" name="bm_textarea" id="bm_textarea">...</textarea>' . "\n";
		}
 
 
		$o .= tag('input class="bm_input" type="hidden" name="backupmail" id="backupmail" value="true"') . "\n"
 . '<p>' . $plugin_tx['backupmail']['mailform_password'] . '</p>' . "\n"
 . tag('input class="bm_password" type="password" name="bm_passwd" id="bm_passwd" value=""') . tag('br') . "\n"
 . tag('input style="clear: both; padding: 1px 5px 2px 5px; margin-top: 10px;" type="submit" name="submit" value="' . $plugin_tx['backupmail']['mailform_submit_backup_mail'] . '"') . '
</form>
</div>
<p style="text-align: center; font-weight: 700;"><a href="./">' . $plugin_tx['backupmail']['mailform_no_backup_mail'] . '</a></p>
';
	}
	else
	{
		// error message wrong password
		if(($cmsimple_pwHasher && !$cmsimple_pwHasher->CheckPassword($_POST['bm_passwd'], $cf['security']['password'])) || (!$cmsimple_pwHasher && $_POST['bm_passwd'] != $cf['security']['password']))
		{
			$o.='
<h4 style="text-align: center;">' . $plugin_tx['backupmail']['mailform_headline'] . '</h4>
<div id="backupmail_error">
<p style="text-align: center;"><b>' . $plugin_tx['backupmail']['error_wrong_password'] . '</b></p>
<p style="text-align: center;"><a href="./?&logout">' . $plugin_tx['backupmail']['error_try_again'] . '</a></p>
</div>
';
		}
		
		// error message both datafiles empty
		if(file_get_contents($plugin_cf['backupmail']['data_file_files']) == '' && file_get_contents($plugin_cf['backupmail']['data_file_folders']) == '' && $_POST['bm_create_backup'])
		{
			$o.='
<h4 style="text-align: center;">' . $plugin_tx['backupmail']['mailform_headline'] . '</h4>
<div id="backupmail_success">
<p style="text-align: center;">' . $plugin_tx['backupmail']['error_datafiles_empty'] . '</p>
</div>';
		}
	
		// success messages
		
		if(($cmsimple_pwHasher && $cmsimple_pwHasher->CheckPassword($_POST['bm_passwd'], $cf['security']['password'])) || (!$cmsimple_pwHasher && $_POST['bm_passwd'] == $cf['security']['password']))
		{
			// success sent backupmail
			if(isset($_POST['bm_send_backupmail']))
			{
				$o.='
<h4 style="text-align: center;">' . $plugin_tx['backupmail']['mailform_headline'] . '</h4>
<div id="backupmail_success">
<p style="text-align: center;">' . $plugin_tx['backupmail']['success_mail_sent'] . '</p>
</div>';
			}
			
			// success created backup
			if(isset($_POST['bm_create_backup']) && (file_get_contents($plugin_cf['backupmail']['data_file_files']) != '' || file_get_contents($plugin_cf['backupmail']['data_file_folders'])) != '')
			{
				$o.='
<h4 style="text-align: center;">' . $plugin_tx['backupmail']['mailform_headline'] . '</h4>
<div id="backupmail_success">
<p style="text-align: center;">' . $plugin_tx['backupmail']['success_backup_created'] . '</p>
</div>';
			}
		}
	}
}


// password protection

if
(
(isset($_POST['bm_passwd']) && $cmsimple_pwHasher && $cmsimple_pwHasher->CheckPassword($_POST['bm_passwd'], $cf['security']['password'])) || 
(isset($_POST['bm_passwd']) && !$cmsimple_pwHasher && $_POST['bm_passwd'] == $cf['security']['password'])
)
{
	createBackupZipArray();
	if($plugin_cf['backupmail']['create_zip_files'] == 'true')
	{
		createBackupZip(); // only if zip is activated
	}
	createZipfilesArray();
	deleteBackupZip();
	bmPrepareMaildata();
	bmSendBackupMail();
}

?>